/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.devtools.build.lib.skyframe.serialization.NotSerializableRuntimeException;
import java.io.NotSerializableException;
import java.util.ArrayList;

public class SerializationException
extends Exception {
    public SerializationException(String msg) {
        super(msg);
    }

    public SerializationException(String msg, Throwable cause) {
        super(msg, cause);
    }

    public static SerializationException propagate(String msg, Throwable cause) {
        if (cause instanceof NoCodecException) {
            return new NoCodecException(msg, (NoCodecException)cause);
        }
        return new SerializationException(msg, cause);
    }

    public static class NoCodecException
    extends SerializationException {
        ArrayList<String> trail = new ArrayList();

        NoCodecException(String message) {
            super(message);
        }

        NoCodecException(String message, NotSerializableException e) {
            super(message, e);
        }

        NoCodecException(String message, NotSerializableRuntimeException e) {
            super(message, e);
        }

        NoCodecException(String message, NoCodecException e) {
            super(message, e);
        }

        @Override
        public String getMessage() {
            return super.getMessage() + (this.trail.isEmpty() ? "" : " " + this.trail);
        }

        public void addTrail(Class<?> type) {
            this.trail.add(type.getName());
        }
    }
}

