/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.common.collect.ImmutableMap;
import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodecRegistry;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.devtools.build.lib.skyframe.serialization.SerializationResult;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ObjectCodecs {
    private final SerializationContext serializationContext;
    private final DeserializationContext deserializationContext;

    public ObjectCodecs(ObjectCodecRegistry codecRegistry, ImmutableMap<Class<?>, Object> dependencies) {
        this.serializationContext = new SerializationContext(codecRegistry, dependencies);
        this.deserializationContext = new DeserializationContext(codecRegistry, dependencies);
    }

    public ObjectCodecs(ObjectCodecRegistry codecRegistry) {
        this(codecRegistry, ImmutableMap.of());
    }

    public ByteString serialize(Object subject) throws SerializationException {
        return ObjectCodecs.serializeToByteString(subject, this::serialize);
    }

    public void serialize(Object subject, CodedOutputStream codedOut) throws SerializationException {
        this.serializeImpl(subject, codedOut, this.serializationContext);
    }

    public ByteString serializeMemoized(Object subject) throws SerializationException {
        return ObjectCodecs.serializeToByteString(subject, this::serializeMemoized);
    }

    public SerializationResult<ByteString> serializeMemoizedAndBlocking(Object subject) throws SerializationException {
        SerializationContext memoizingContext = this.serializationContext.getMemoizingAndBlockingOnWriteContext();
        ByteString byteString = ObjectCodecs.serializeToByteString(subject, (subj, codedOut) -> this.serializeImpl(subj, codedOut, memoizingContext));
        return SerializationResult.create(byteString, memoizingContext.createFutureToBlockWritingOn());
    }

    public void serializeMemoized(Object subject, CodedOutputStream codedOut) throws SerializationException {
        this.serializeImpl(subject, codedOut, this.serializationContext.getMemoizingContext());
    }

    public Object deserialize(ByteString data) throws SerializationException {
        return this.deserialize(data.newCodedInput());
    }

    public Object deserialize(CodedInputStream codedIn) throws SerializationException {
        return this.deserializeImpl(codedIn, false);
    }

    public Object deserializeMemoized(ByteString data) throws SerializationException {
        return this.deserializeMemoized(data.newCodedInput());
    }

    public Object deserializeMemoized(CodedInputStream codedIn) throws SerializationException {
        return this.deserializeImpl(codedIn, true);
    }

    private void serializeImpl(Object subject, CodedOutputStream codedOut, SerializationContext serializationContext) throws SerializationException {
        try {
            serializationContext.serialize(subject, codedOut);
        }
        catch (IOException e) {
            throw new SerializationException("Failed to serialize " + subject, e);
        }
    }

    private Object deserializeImpl(CodedInputStream codedIn, boolean memoize) throws SerializationException {
        codedIn.enableAliasing(true);
        try {
            if (memoize) {
                return this.deserializationContext.getMemoizingContext().deserialize(codedIn);
            }
            return this.deserializationContext.deserialize(codedIn);
        }
        catch (IOException e) {
            throw new SerializationException("Failed to deserialize data", e);
        }
    }

    private static ByteString serializeToByteString(Object subject, SerializeCall wrapped) throws SerializationException {
        ByteString.Output resultOut = ByteString.newOutput();
        CodedOutputStream codedOut = CodedOutputStream.newInstance((OutputStream)resultOut);
        wrapped.serialize(subject, codedOut);
        try {
            codedOut.flush();
            return resultOut.toByteString();
        }
        catch (IOException e) {
            throw new SerializationException("Failed to serialize " + subject, e);
        }
    }

    @FunctionalInterface
    private static interface SerializeCall {
        public void serialize(Object var1, CodedOutputStream var2) throws SerializationException;
    }
}

