/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

public class ImmutableMultimapCodec<K, V>
implements ObjectCodec<ImmutableMultimap<K, V>> {
    @Override
    public Class<? extends ImmutableMultimap<K, V>> getEncodedClass() {
        return ImmutableMultimap.class;
    }

    @Override
    public void serialize(SerializationContext context, ImmutableMultimap<K, V> obj, CodedOutputStream codedOut) throws SerializationException, IOException {
        if (obj instanceof ImmutableListMultimap) {
            codedOut.writeBoolNoTag(true);
        } else if (obj instanceof ImmutableSetMultimap) {
            codedOut.writeBoolNoTag(false);
        } else {
            throw new SerializationException("Unexpected multimap type: " + obj.getClass());
        }
        codedOut.writeInt32NoTag(obj.asMap().size());
        for (Map.Entry entry : obj.asMap().entrySet()) {
            context.serialize(entry.getKey(), codedOut);
            context.serialize(entry.getValue(), codedOut);
        }
    }

    @Override
    public ImmutableMultimap<K, V> deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
        Object result = codedIn.readBool() ? ImmutableListMultimap.builder() : ImmutableSetMultimap.builder();
        int length = codedIn.readInt32();
        for (int i = 0; i < length; ++i) {
            Object key = context.deserialize(codedIn);
            Collection values = (Collection)context.deserialize(codedIn);
            result.putAll(key, (Iterable)values);
        }
        return result.build();
    }
}

