/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.client;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.impl.client.BaseClientAddListenerRequest;
import com.hazelcast.map.MapPartitionLostEvent;
import com.hazelcast.map.impl.MapPortableHook;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.listener.MapPartitionLostListener;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.impl.PortableMapPartitionLostEvent;
import java.io.IOException;
import java.security.Permission;

public class MapAddPartitionLostListenerRequest
extends BaseClientAddListenerRequest {
    private String name;

    public MapAddPartitionLostListenerRequest() {
    }

    public MapAddPartitionLostListenerRequest(String name) {
        this.name = name;
    }

    public Object call() {
        final ClientEndpoint endpoint = this.getEndpoint();
        MapPartitionLostListener listener = new MapPartitionLostListener(){

            @Override
            public void partitionLost(MapPartitionLostEvent event) {
                if (endpoint.isAlive()) {
                    PortableMapPartitionLostEvent portableEvent = new PortableMapPartitionLostEvent(event.getPartitionId(), event.getMember().getUuid());
                    endpoint.sendEvent(null, portableEvent, MapAddPartitionLostListenerRequest.this.getCallId());
                }
            }
        };
        MapService mapService = (MapService)this.getService();
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        String registrationId = this.localOnly ? mapServiceContext.addLocalPartitionLostListener(listener, this.name) : mapServiceContext.addPartitionLostListener(listener, this.name);
        endpoint.addListenerDestroyAction("hz:impl:mapService", this.name, registrationId);
        return registrationId;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.writeUTF("name", this.name);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.name = reader.readUTF("name");
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public String getMethodName() {
        return "addPartitionLostListener";
    }

    @Override
    public int getFactoryId() {
        return MapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 51;
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(this.name, "listen");
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{null};
    }
}

