/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.bind.annotation;

import java.io.Serializable;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.auxiliary.AuxiliaryType;
import net.bytebuddy.implementation.bind.MethodDelegationBinder;
import net.bytebuddy.implementation.bind.annotation.TargetMethodAnnotationDrivenBinder;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.Duplication;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.TypeCreation;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.ByteBuddyCommons;
import org.objectweb.asm.MethodVisitor;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface Pipe {
    public boolean serializableProxy() default false;

    public static class Binder
    implements TargetMethodAnnotationDrivenBinder.ParameterBinder<Pipe> {
        private final MethodDescription forwardingMethod;

        protected Binder(MethodDescription forwardingMethod) {
            this.forwardingMethod = forwardingMethod;
        }

        public static TargetMethodAnnotationDrivenBinder.ParameterBinder<Pipe> install(Class<?> type) {
            return Binder.install(new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(type)));
        }

        public static TargetMethodAnnotationDrivenBinder.ParameterBinder<Pipe> install(TypeDescription typeDescription) {
            return new Binder(Binder.onlyMethod(ByteBuddyCommons.nonNull(typeDescription)));
        }

        private static MethodDescription onlyMethod(TypeDescription typeDescription) {
            if (!typeDescription.isInterface()) {
                throw new IllegalArgumentException(typeDescription + " is not an interface");
            }
            if (!typeDescription.getInterfaces().isEmpty()) {
                throw new IllegalArgumentException(typeDescription + " must not extend other interfaces");
            }
            if (!typeDescription.isPublic()) {
                throw new IllegalArgumentException(typeDescription + " is mot public");
            }
            MethodList methodCandidates = (MethodList)typeDescription.getDeclaredMethods().filter(ElementMatchers.not(ElementMatchers.isStatic()));
            if (methodCandidates.size() != 1) {
                throw new IllegalArgumentException(typeDescription + " must declare exactly one non-static method");
            }
            MethodDescription methodDescription = (MethodDescription)methodCandidates.getOnly();
            if (!methodDescription.getReturnType().asErasure().represents((Type)((Object)Object.class))) {
                throw new IllegalArgumentException(methodDescription + " does not return an Object-type");
            }
            if (methodDescription.getParameters().size() != 1 || !((ParameterDescription)methodDescription.getParameters().getOnly()).getType().asErasure().represents((Type)((Object)Object.class))) {
                throw new IllegalArgumentException(methodDescription + " does not take a single Object-typed argument");
            }
            return methodDescription;
        }

        @Override
        public Class<Pipe> getHandledType() {
            return Pipe.class;
        }

        @Override
        public MethodDelegationBinder.ParameterBinding<?> bind(AnnotationDescription.Loadable<Pipe> annotation, MethodDescription source, ParameterDescription target, Implementation.Target implementationTarget, Assigner assigner) {
            if (!target.getType().asErasure().equals(this.forwardingMethod.getDeclaringType())) {
                throw new IllegalStateException("Illegal use of @Pipe for " + target + " which was installed for " + this.forwardingMethod.getDeclaringType());
            }
            if (source.isStatic()) {
                return MethodDelegationBinder.ParameterBinding.Illegal.INSTANCE;
            }
            return new MethodDelegationBinder.ParameterBinding.Anonymous(new Redirection(this.forwardingMethod.getDeclaringType().asErasure(), source, assigner, annotation.loadSilent().serializableProxy()));
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.forwardingMethod.equals(((Binder)other).forwardingMethod);
        }

        public int hashCode() {
            return this.forwardingMethod.hashCode();
        }

        public String toString() {
            return "Pipe.Binder{forwardingMethod=" + this.forwardingMethod + '}';
        }

        protected static class Redirection
        implements AuxiliaryType,
        StackManipulation {
            private static final String FIELD_NAME_PREFIX = "argument";
            private final TypeDescription forwardingType;
            private final MethodDescription sourceMethod;
            private final Assigner assigner;
            private final boolean serializableProxy;

            protected Redirection(TypeDescription forwardingType, MethodDescription sourceMethod, Assigner assigner, boolean serializableProxy) {
                this.forwardingType = forwardingType;
                this.sourceMethod = sourceMethod;
                this.assigner = assigner;
                this.serializableProxy = serializableProxy;
            }

            private static LinkedHashMap<String, TypeDescription> extractFields(MethodDescription methodDescription) {
                TypeList parameterTypes = methodDescription.getParameters().asTypeList().asErasures();
                LinkedHashMap<String, TypeDescription> typeDescriptions = new LinkedHashMap<String, TypeDescription>(parameterTypes.size());
                int currentIndex = 0;
                for (TypeDescription parameterType : parameterTypes) {
                    typeDescriptions.put(Redirection.fieldName(currentIndex++), parameterType);
                }
                return typeDescriptions;
            }

            private static String fieldName(int index) {
                return String.format("%s%d", FIELD_NAME_PREFIX, index);
            }

            @Override
            public DynamicType make(String auxiliaryTypeName, ClassFileVersion classFileVersion, AuxiliaryType.MethodAccessorFactory methodAccessorFactory) {
                Class[] classArray;
                LinkedHashMap<String, TypeDescription> parameterFields = Redirection.extractFields(this.sourceMethod);
                DynamicType.Builder builder = new ByteBuddy(classFileVersion).subclass(this.forwardingType, (ConstructorStrategy)ConstructorStrategy.Default.NO_CONSTRUCTORS).name(auxiliaryTypeName).modifiers(DEFAULT_TYPE_MODIFIER);
                if (this.serializableProxy) {
                    Class[] classArray2 = new Class[1];
                    classArray = classArray2;
                    classArray2[0] = Serializable.class;
                } else {
                    classArray = new Class[]{};
                }
                DynamicType.Builder<Object> builder2 = builder.implement(classArray).method(ElementMatchers.isDeclaredBy(this.forwardingType)).intercept(new MethodCall(this.sourceMethod, this.assigner)).defineConstructor((List<TypeDescription>)new ArrayList<TypeDescription>(parameterFields.values()), new ModifierContributor.ForMethod[0]).intercept(ConstructorCall.INSTANCE);
                for (Map.Entry<String, TypeDescription> field : parameterFields.entrySet()) {
                    builder2 = builder2.defineField(field.getKey(), field.getValue(), Visibility.PRIVATE);
                }
                return builder2.make();
            }

            @Override
            public boolean isValid() {
                return true;
            }

            @Override
            public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                TypeDescription forwardingType = implementationContext.register(this);
                return new StackManipulation.Compound(TypeCreation.forType(forwardingType), Duplication.SINGLE, MethodVariableAccess.allArgumentsOf(this.sourceMethod), MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)forwardingType.getDeclaredMethods().filter(ElementMatchers.isConstructor())).getOnly())).apply(methodVisitor, implementationContext);
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                Redirection that = (Redirection)other;
                return this.serializableProxy == that.serializableProxy && this.assigner.equals(that.assigner) && this.forwardingType.equals(that.forwardingType) && this.sourceMethod.equals(that.sourceMethod);
            }

            public int hashCode() {
                int result = this.forwardingType.hashCode();
                result = 31 * result + this.sourceMethod.hashCode();
                result = 31 * result + this.assigner.hashCode();
                result = 31 * result + (this.serializableProxy ? 1 : 0);
                return result;
            }

            public String toString() {
                return "Pipe.Binder.Redirection{forwardingType=" + this.forwardingType + ", sourceMethod=" + this.sourceMethod + ", assigner=" + this.assigner + ", serializableProxy=" + this.serializableProxy + '}';
            }

            protected static class MethodCall
            implements Implementation {
                private final MethodDescription redirectedMethod;
                private final Assigner assigner;

                private MethodCall(MethodDescription redirectedMethod, Assigner assigner) {
                    this.redirectedMethod = redirectedMethod;
                    this.assigner = assigner;
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                @Override
                public ByteCodeAppender appender(Implementation.Target implementationTarget) {
                    return new Appender(implementationTarget.getTypeDescription());
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.redirectedMethod.equals(((MethodCall)other).redirectedMethod) && this.assigner.equals(((MethodCall)other).assigner);
                }

                public int hashCode() {
                    return this.redirectedMethod.hashCode() + 31 * this.assigner.hashCode();
                }

                public String toString() {
                    return "Pipe.Binder.Redirection.MethodCall{redirectedMethod=" + this.redirectedMethod + ", assigner=" + this.assigner + '}';
                }

                private class Appender
                implements ByteCodeAppender {
                    private final TypeDescription instrumentedType;

                    private Appender(TypeDescription instrumentedType) {
                        this.instrumentedType = instrumentedType;
                    }

                    @Override
                    public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                        StackManipulation thisReference = MethodVariableAccess.forType(this.instrumentedType).loadOffset(0);
                        FieldList<FieldDescription.InDefinedShape> fieldList = this.instrumentedType.getDeclaredFields();
                        StackManipulation[] fieldLoading = new StackManipulation[fieldList.size()];
                        int index = 0;
                        for (FieldDescription fieldDescription : fieldList) {
                            fieldLoading[index++] = new StackManipulation.Compound(thisReference, FieldAccess.forField(fieldDescription).getter());
                        }
                        StackManipulation.Size stackSize = new StackManipulation.Compound(MethodVariableAccess.REFERENCE.loadOffset(1), MethodCall.this.assigner.assign(TypeDescription.OBJECT, MethodCall.this.redirectedMethod.getDeclaringType().asErasure(), Assigner.Typing.DYNAMIC), new StackManipulation.Compound(fieldLoading), MethodInvocation.invoke(MethodCall.this.redirectedMethod), MethodCall.this.assigner.assign(MethodCall.this.redirectedMethod.getReturnType().asErasure(), instrumentedMethod.getReturnType().asErasure(), Assigner.Typing.DYNAMIC), MethodReturn.REFERENCE).apply(methodVisitor, implementationContext);
                        return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
                    }

                    private MethodCall getMethodCall() {
                        return MethodCall.this;
                    }

                    public boolean equals(Object other) {
                        return this == other || other != null && this.getClass() == other.getClass() && this.instrumentedType.equals(((Appender)other).instrumentedType) && MethodCall.this.equals(((Appender)other).getMethodCall());
                    }

                    public int hashCode() {
                        return 31 * MethodCall.this.hashCode() + this.instrumentedType.hashCode();
                    }

                    public String toString() {
                        return "Pipe.Binder.Redirection.MethodCall.Appender{methodCall=" + MethodCall.this + ", instrumentedType=" + this.instrumentedType + '}';
                    }
                }
            }

            protected static enum ConstructorCall implements Implementation
            {
                INSTANCE;

                private final MethodDescription objectTypeDefaultConstructor = (MethodDescription)((MethodList)TypeDescription.OBJECT.getDeclaredMethods().filter(ElementMatchers.isConstructor())).getOnly();

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                @Override
                public ByteCodeAppender appender(Implementation.Target implementationTarget) {
                    return new Appender(implementationTarget.getTypeDescription());
                }

                public String toString() {
                    return "Pipe.Binder.Redirection.ConstructorCall." + this.name();
                }

                private static class Appender
                implements ByteCodeAppender {
                    private final TypeDescription instrumentedType;

                    private Appender(TypeDescription instrumentedType) {
                        this.instrumentedType = instrumentedType;
                    }

                    @Override
                    public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                        StackManipulation thisReference = MethodVariableAccess.REFERENCE.loadOffset(0);
                        FieldList<FieldDescription.InDefinedShape> fieldList = this.instrumentedType.getDeclaredFields();
                        StackManipulation[] fieldLoading = new StackManipulation[fieldList.size()];
                        int index = 0;
                        for (FieldDescription fieldDescription : fieldList) {
                            fieldLoading[index] = new StackManipulation.Compound(thisReference, MethodVariableAccess.forType(fieldDescription.getType().asErasure()).loadOffset(((ParameterDescription)instrumentedMethod.getParameters().get(index)).getOffset()), FieldAccess.forField(fieldDescription).putter());
                            ++index;
                        }
                        StackManipulation.Size stackSize = new StackManipulation.Compound(thisReference, MethodInvocation.invoke(INSTANCE.objectTypeDefaultConstructor), new StackManipulation.Compound(fieldLoading), MethodReturn.VOID).apply(methodVisitor, implementationContext);
                        return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
                    }

                    public boolean equals(Object other) {
                        return this == other || other != null && this.getClass() == other.getClass() && this.instrumentedType.equals(((Appender)other).instrumentedType);
                    }

                    public int hashCode() {
                        return this.instrumentedType.hashCode();
                    }

                    public String toString() {
                        return "Pipe.Binder.Redirection.ConstructorCall.Appender{instrumentedType=" + this.instrumentedType + '}';
                    }
                }
            }
        }
    }
}

