/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.impl.queue.client;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.impl.client.BaseClientAddListenerRequest;
import com.hazelcast.collection.common.DataAwareItemEvent;
import com.hazelcast.collection.impl.queue.QueuePortableHook;
import com.hazelcast.collection.impl.queue.QueueService;
import com.hazelcast.core.ItemEvent;
import com.hazelcast.core.ItemListener;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.QueuePermission;
import com.hazelcast.spi.impl.PortableItemEvent;
import java.io.IOException;
import java.security.Permission;

public class AddListenerRequest
extends BaseClientAddListenerRequest {
    private String name;
    private boolean includeValue;

    public AddListenerRequest() {
    }

    public AddListenerRequest(String name, boolean includeValue) {
        this.name = name;
        this.includeValue = includeValue;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:queueService";
    }

    @Override
    public int getFactoryId() {
        return QueuePortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 12;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.writeUTF("n", this.name);
        writer.writeBoolean("i", this.includeValue);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.name = reader.readUTF("n");
        this.includeValue = reader.readBoolean("i");
    }

    public Object call() throws Exception {
        final ClientEndpoint endpoint = this.getEndpoint();
        QueueService service = (QueueService)this.getService();
        Object partitionKey = this.serializationService.toData(this.name);
        ItemListener listener = new ItemListener((Data)partitionKey){
            final /* synthetic */ Data val$partitionKey;
            {
                this.val$partitionKey = data;
            }

            public void itemAdded(ItemEvent item) {
                this.send(item);
            }

            public void itemRemoved(ItemEvent item) {
                this.send(item);
            }

            private void send(ItemEvent event) {
                if (endpoint.isAlive()) {
                    if (!(event instanceof DataAwareItemEvent)) {
                        throw new IllegalArgumentException("Expecting: DataAwareItemEvent, Found: " + event.getClass().getSimpleName());
                    }
                    DataAwareItemEvent dataAwareItemEvent = (DataAwareItemEvent)event;
                    Data item = dataAwareItemEvent.getItemData();
                    PortableItemEvent portableItemEvent = new PortableItemEvent(item, event.getEventType(), event.getMember().getUuid());
                    endpoint.sendEvent(this.val$partitionKey, portableItemEvent, AddListenerRequest.this.getCallId());
                }
            }
        };
        String registrationId = service.addItemListener(this.name, listener, this.includeValue, this.localOnly);
        endpoint.addListenerDestroyAction("hz:impl:queueService", this.name, registrationId);
        return registrationId;
    }

    @Override
    public Permission getRequiredPermission() {
        return new QueuePermission(this.name, "listen");
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }

    @Override
    public String getMethodName() {
        return "addItemListener";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{null, this.includeValue};
    }
}

