/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.lower;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.turbine.binder.DisambiguateTypeAnnotations;
import com.google.turbine.binder.bound.AnnotationValue;
import com.google.turbine.binder.bound.ClassValue;
import com.google.turbine.binder.bound.EnumConstantValue;
import com.google.turbine.binder.bound.ModuleInfo;
import com.google.turbine.binder.bound.SourceTypeBoundClass;
import com.google.turbine.binder.bound.TypeBoundClass;
import com.google.turbine.binder.bytecode.BytecodeBoundClass;
import com.google.turbine.binder.env.CompoundEnv;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.env.SimpleEnv;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.Symbol;
import com.google.turbine.binder.sym.TyVarSymbol;
import com.google.turbine.bytecode.ClassFile;
import com.google.turbine.bytecode.ClassWriter;
import com.google.turbine.bytecode.sig.Sig;
import com.google.turbine.bytecode.sig.SigWriter;
import com.google.turbine.lower.LowerSignature;
import com.google.turbine.model.Const;
import com.google.turbine.model.TurbineVisibility;
import com.google.turbine.type.AnnoInfo;
import com.google.turbine.type.Type;
import com.google.turbine.types.Erasure;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class Lower {
    private final LowerSignature sig = new LowerSignature();
    private final Env<ClassSymbol, TypeBoundClass> env;
    private static final int PARAMETER_ACCESS_MASK = 36880;

    public static Lowered lowerAll(ImmutableMap<ClassSymbol, SourceTypeBoundClass> units, ImmutableList<ModuleInfo> modules, Env<ClassSymbol, BytecodeBoundClass> classpath) {
        CompoundEnv<ClassSymbol, TypeBoundClass> env = CompoundEnv.of(classpath).append(new SimpleEnv<ClassSymbol, SourceTypeBoundClass>(units));
        ImmutableMap.Builder result = ImmutableMap.builder();
        LinkedHashSet<ClassSymbol> symbols = new LinkedHashSet<ClassSymbol>();
        for (ClassSymbol sym : units.keySet()) {
            result.put((Object)sym.binaryName(), (Object)Lower.lower((SourceTypeBoundClass)units.get((Object)sym), env, sym, symbols));
        }
        if (modules.size() == 1) {
            result.put((Object)"module-info", (Object)Lower.lower((ModuleInfo)Iterables.getOnlyElement(modules), env, symbols));
        } else {
            for (ModuleInfo module : modules) {
                result.put((Object)(module.name().replace('.', '/') + "/module-info"), (Object)Lower.lower(module, env, symbols));
            }
        }
        return new Lowered((ImmutableMap<String, byte[]>)result.build(), (ImmutableSet<ClassSymbol>)ImmutableSet.copyOf(symbols));
    }

    public static byte[] lower(SourceTypeBoundClass info, Env<ClassSymbol, TypeBoundClass> env, ClassSymbol sym, Set<ClassSymbol> symbols) {
        return new Lower(env).lower(info, sym, symbols);
    }

    private static byte[] lower(ModuleInfo module, CompoundEnv<ClassSymbol, TypeBoundClass> env, Set<ClassSymbol> symbols) {
        return new Lower(env).lower(module, symbols);
    }

    public Lower(Env<ClassSymbol, TypeBoundClass> env) {
        this.env = env;
    }

    private byte[] lower(ModuleInfo module, Set<ClassSymbol> symbols) {
        String name = "module-info";
        ImmutableList<ClassFile.AnnotationInfo> annotations = this.lowerAnnotations(module.annos());
        ClassFile.ModuleInfo moduleInfo = this.lowerModule(module);
        ImmutableList.Builder innerClasses = ImmutableList.builder();
        LinkedHashSet<ClassSymbol> all = new LinkedHashSet<ClassSymbol>();
        for (ClassSymbol sym : this.sig.classes) {
            this.addEnclosing(this.env, all, sym);
        }
        for (ClassSymbol innerSym : all) {
            innerClasses.add((Object)this.innerClass(this.env, innerSym));
        }
        ClassFile classfile = new ClassFile(32768, name, null, null, (List<String>)ImmutableList.of(), (List<ClassFile.MethodInfo>)ImmutableList.of(), (List<ClassFile.FieldInfo>)ImmutableList.of(), (List<ClassFile.AnnotationInfo>)annotations, (List<ClassFile.InnerClass>)innerClasses.build(), (ImmutableList<ClassFile.TypeAnnotationInfo>)ImmutableList.of(), moduleInfo);
        symbols.addAll(this.sig.classes);
        return ClassWriter.writeClass(classfile);
    }

    private ClassFile.ModuleInfo lowerModule(ModuleInfo module) {
        ImmutableList.Builder requires = ImmutableList.builder();
        for (ModuleInfo.RequireInfo require : module.requires()) {
            requires.add((Object)new ClassFile.ModuleInfo.RequireInfo(require.moduleName(), require.flags(), require.version()));
        }
        ImmutableList.Builder exports = ImmutableList.builder();
        for (ModuleInfo.ExportInfo export : module.exports()) {
            int exportAccess = 0;
            exports.add((Object)new ClassFile.ModuleInfo.ExportInfo(export.packageName(), exportAccess, export.modules()));
        }
        ImmutableList.Builder opens = ImmutableList.builder();
        for (ModuleInfo.OpenInfo open : module.opens()) {
            int openAccess = 0;
            opens.add((Object)new ClassFile.ModuleInfo.OpenInfo(open.packageName(), openAccess, open.modules()));
        }
        ImmutableList.Builder uses = ImmutableList.builder();
        for (ModuleInfo.UseInfo use : module.uses()) {
            uses.add((Object)new ClassFile.ModuleInfo.UseInfo(this.sig.descriptor(use.sym())));
        }
        ImmutableList.Builder provides = ImmutableList.builder();
        for (ModuleInfo.ProvideInfo provide : module.provides()) {
            ImmutableList.Builder impls = ImmutableList.builder();
            for (ClassSymbol impl : provide.impls()) {
                impls.add((Object)this.sig.descriptor(impl));
            }
            provides.add((Object)new ClassFile.ModuleInfo.ProvideInfo(this.sig.descriptor(provide.sym()), (ImmutableList<String>)impls.build()));
        }
        return new ClassFile.ModuleInfo(module.name(), module.flags(), module.version(), (ImmutableList<ClassFile.ModuleInfo.RequireInfo>)requires.build(), (ImmutableList<ClassFile.ModuleInfo.ExportInfo>)exports.build(), (ImmutableList<ClassFile.ModuleInfo.OpenInfo>)opens.build(), (ImmutableList<ClassFile.ModuleInfo.UseInfo>)uses.build(), (ImmutableList<ClassFile.ModuleInfo.ProvideInfo>)provides.build());
    }

    private byte[] lower(SourceTypeBoundClass info, ClassSymbol sym, Set<ClassSymbol> symbols) {
        int access = this.classAccess(info);
        String name = this.sig.descriptor(sym);
        String signature = this.sig.classSignature(info);
        String superName = info.superclass() != null ? this.sig.descriptor(info.superclass()) : null;
        ArrayList<String> interfaces = new ArrayList<String>();
        for (ClassSymbol i : info.interfaces()) {
            interfaces.add(this.sig.descriptor(i));
        }
        ArrayList<ClassFile.MethodInfo> methods = new ArrayList<ClassFile.MethodInfo>();
        for (TypeBoundClass.MethodInfo m : info.methods()) {
            if (TurbineVisibility.fromAccess(m.access()) == TurbineVisibility.PRIVATE) continue;
            methods.add(this.lowerMethod(m, sym));
        }
        ImmutableList.Builder fields = ImmutableList.builder();
        for (TypeBoundClass.FieldInfo f : info.fields()) {
            if ((f.access() & 2) == 2) continue;
            fields.add((Object)this.lowerField(f));
        }
        ImmutableList<ClassFile.AnnotationInfo> annotations = this.lowerAnnotations(info.annotations());
        ImmutableList<ClassFile.InnerClass> inners = this.collectInnerClasses(sym, info);
        ImmutableList<ClassFile.TypeAnnotationInfo> typeAnnotations = this.classTypeAnnotations(info);
        ClassFile classfile = new ClassFile(access, name, signature, superName, (List<String>)interfaces, (List<ClassFile.MethodInfo>)methods, (List<ClassFile.FieldInfo>)fields.build(), (List<ClassFile.AnnotationInfo>)annotations, (List<ClassFile.InnerClass>)inners, typeAnnotations, null);
        symbols.addAll(this.sig.classes);
        return ClassWriter.writeClass(classfile);
    }

    private ClassFile.MethodInfo lowerMethod(TypeBoundClass.MethodInfo m, ClassSymbol sym) {
        int access = m.access();
        TyVarEnv tenv = new TyVarEnv((Map<TyVarSymbol, TypeBoundClass.TyVarInfo>)m.tyParams());
        String name = m.name();
        String desc = this.methodDescriptor(m, tenv);
        String signature = this.sig.methodSignature(this.env, m, sym);
        ImmutableList.Builder exceptions = ImmutableList.builder();
        if (!m.exceptions().isEmpty()) {
            for (Type e : m.exceptions()) {
                exceptions.add((Object)this.sig.descriptor(((Type.ClassTy)Erasure.erase(e, tenv)).sym()));
            }
        }
        ClassFile.AnnotationInfo.ElementValue defaultValue = m.defaultValue() != null ? this.annotationValue(m.defaultValue()) : null;
        ImmutableList<ClassFile.AnnotationInfo> annotations = this.lowerAnnotations(m.annotations());
        ImmutableList<ImmutableList<ClassFile.AnnotationInfo>> paramAnnotations = this.parameterAnnotations(m);
        ImmutableList<ClassFile.TypeAnnotationInfo> typeAnnotations = this.methodTypeAnnotations(m);
        ImmutableList<ClassFile.MethodInfo.ParameterInfo> parameters = this.methodParameters(m);
        return new ClassFile.MethodInfo(access, name, desc, signature, (List<String>)exceptions.build(), defaultValue, (List<ClassFile.AnnotationInfo>)annotations, paramAnnotations, typeAnnotations, parameters);
    }

    private ImmutableList<ClassFile.MethodInfo.ParameterInfo> methodParameters(TypeBoundClass.MethodInfo m) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (TypeBoundClass.ParamInfo p : m.parameters()) {
            result.add((Object)new ClassFile.MethodInfo.ParameterInfo(p.name(), p.access() & 0x9010));
        }
        return result.build();
    }

    private ImmutableList<ImmutableList<ClassFile.AnnotationInfo>> parameterAnnotations(TypeBoundClass.MethodInfo m) {
        ImmutableList.Builder annotations = ImmutableList.builder();
        for (TypeBoundClass.ParamInfo parameter : m.parameters()) {
            if (parameter.synthetic()) continue;
            if (parameter.annotations().isEmpty()) {
                annotations.add((Object)ImmutableList.of());
                continue;
            }
            ImmutableList.Builder parameterAnnotations = ImmutableList.builder();
            for (AnnoInfo annotation : parameter.annotations()) {
                Boolean visible = this.isVisible(annotation.sym());
                if (visible == null) continue;
                String desc = this.sig.objectType(annotation.sym());
                parameterAnnotations.add((Object)new ClassFile.AnnotationInfo(desc, visible, (Map<String, ClassFile.AnnotationInfo.ElementValue>)this.annotationValues(annotation.values())));
            }
            annotations.add((Object)parameterAnnotations.build());
        }
        return annotations.build();
    }

    private String methodDescriptor(TypeBoundClass.MethodInfo m, Function<TyVarSymbol, TypeBoundClass.TyVarInfo> tenv) {
        ImmutableList typarams = ImmutableList.of();
        ImmutableList.Builder fparams = ImmutableList.builder();
        for (TypeBoundClass.ParamInfo t : m.parameters()) {
            fparams.add((Object)this.sig.signature(Erasure.erase(t.type(), tenv)));
        }
        Sig.TySig result = this.sig.signature(Erasure.erase(m.returnType(), tenv));
        ImmutableList excns = ImmutableList.of();
        return SigWriter.method(new Sig.MethodSig((ImmutableList<Sig.TyParamSig>)typarams, (ImmutableList<Sig.TySig>)fparams.build(), result, (ImmutableList<Sig.TySig>)excns));
    }

    private ClassFile.FieldInfo lowerField(TypeBoundClass.FieldInfo f) {
        String name = f.name();
        TyVarEnv tenv = new TyVarEnv(Collections.emptyMap());
        String desc = SigWriter.type(this.sig.signature(Erasure.erase(f.type(), tenv)));
        String signature = this.sig.fieldSignature(f.type());
        ImmutableList<ClassFile.AnnotationInfo> annotations = this.lowerAnnotations(f.annotations());
        ImmutableList.Builder typeAnnotations = ImmutableList.builder();
        this.lowerTypeAnnotations((ImmutableList.Builder<ClassFile.TypeAnnotationInfo>)typeAnnotations, f.type(), ClassFile.TypeAnnotationInfo.TargetType.FIELD, ClassFile.TypeAnnotationInfo.EMPTY_TARGET);
        return new ClassFile.FieldInfo(f.access(), name, desc, signature, f.value(), (List<ClassFile.AnnotationInfo>)annotations, (ImmutableList<ClassFile.TypeAnnotationInfo>)typeAnnotations.build());
    }

    private ImmutableList<ClassFile.InnerClass> collectInnerClasses(ClassSymbol origin, SourceTypeBoundClass info) {
        LinkedHashSet<ClassSymbol> all = new LinkedHashSet<ClassSymbol>();
        this.addEnclosing(this.env, all, origin);
        for (ClassSymbol sym : info.children().values()) {
            this.addEnclosing(this.env, all, sym);
        }
        for (ClassSymbol sym : this.sig.classes) {
            this.addEnclosing(this.env, all, sym);
        }
        ImmutableList.Builder inners = ImmutableList.builder();
        for (ClassSymbol innerSym : all) {
            inners.add((Object)this.innerClass(this.env, innerSym));
        }
        return inners.build();
    }

    private void addEnclosing(Env<ClassSymbol, TypeBoundClass> env, Set<ClassSymbol> all, ClassSymbol sym) {
        TypeBoundClass info = env.get(sym);
        if (info == null) {
            throw new AssertionError(sym);
        }
        ClassSymbol owner = env.get(sym).owner();
        if (owner != null) {
            this.addEnclosing(env, all, owner);
            all.add(sym);
        }
    }

    private ClassFile.InnerClass innerClass(Env<ClassSymbol, TypeBoundClass> env, ClassSymbol innerSym) {
        TypeBoundClass inner = env.get(innerSym);
        String innerName = innerSym.binaryName().substring(inner.owner().binaryName().length() + 1);
        int access = inner.access();
        return new ClassFile.InnerClass(innerSym.binaryName(), inner.owner().binaryName(), innerName, access &= 0xFFFFF7DF);
    }

    private int classAccess(SourceTypeBoundClass info) {
        int access = info.access();
        if (((access &= 0xFFFFF7F5) & 4) != 0) {
            access &= 0xFFFFFFFB;
            access |= 1;
        }
        return access;
    }

    private ImmutableList<ClassFile.AnnotationInfo> lowerAnnotations(ImmutableList<AnnoInfo> annotations) {
        ImmutableList.Builder lowered = ImmutableList.builder();
        for (AnnoInfo annotation : annotations) {
            ClassFile.AnnotationInfo anno = this.lowerAnnotation(annotation);
            if (anno == null) continue;
            lowered.add((Object)anno);
        }
        return lowered.build();
    }

    private ClassFile.AnnotationInfo lowerAnnotation(AnnoInfo annotation) {
        Boolean visible = this.isVisible(annotation.sym());
        if (visible == null) {
            return null;
        }
        return new ClassFile.AnnotationInfo(this.sig.objectType(annotation.sym()), visible, (Map<String, ClassFile.AnnotationInfo.ElementValue>)this.annotationValues(annotation.values()));
    }

    @Nullable
    private Boolean isVisible(ClassSymbol sym) {
        RetentionPolicy retention = this.env.get(sym).annotationMetadata().retention();
        switch (retention) {
            case CLASS: {
                return false;
            }
            case RUNTIME: {
                return true;
            }
            case SOURCE: {
                return null;
            }
        }
        throw new AssertionError((Object)retention);
    }

    private ImmutableMap<String, ClassFile.AnnotationInfo.ElementValue> annotationValues(ImmutableMap<String, Const> values) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Map.Entry entry : values.entrySet()) {
            result.put(entry.getKey(), (Object)this.annotationValue((Const)entry.getValue()));
        }
        return result.build();
    }

    private ClassFile.AnnotationInfo.ElementValue annotationValue(Const value) {
        switch (value.kind()) {
            case CLASS_LITERAL: {
                ClassValue classValue = (ClassValue)value;
                return new ClassFile.AnnotationInfo.ElementValue.ConstClassValue(SigWriter.type(this.sig.signature(classValue.type())));
            }
            case ENUM_CONSTANT: {
                EnumConstantValue enumValue = (EnumConstantValue)value;
                return new ClassFile.AnnotationInfo.ElementValue.EnumConstValue(this.sig.objectType(enumValue.sym().owner()), enumValue.sym().name());
            }
            case ARRAY: {
                Const.ArrayInitValue arrayValue = (Const.ArrayInitValue)value;
                ArrayList<ClassFile.AnnotationInfo.ElementValue> values = new ArrayList<ClassFile.AnnotationInfo.ElementValue>();
                for (Const element : arrayValue.elements()) {
                    values.add(this.annotationValue(element));
                }
                return new ClassFile.AnnotationInfo.ElementValue.ArrayValue(values);
            }
            case ANNOTATION: {
                AnnotationValue annotationValue = (AnnotationValue)value;
                Boolean visible = this.isVisible(annotationValue.sym());
                if (visible == null) {
                    visible = true;
                }
                return new ClassFile.AnnotationInfo.ElementValue.AnnotationValue(new ClassFile.AnnotationInfo(this.sig.objectType(annotationValue.sym()), visible, (Map<String, ClassFile.AnnotationInfo.ElementValue>)this.annotationValues(annotationValue.values())));
            }
            case PRIMITIVE: {
                return new ClassFile.AnnotationInfo.ElementValue.ConstValue((Const.Value)value);
            }
        }
        throw new AssertionError((Object)value.kind());
    }

    private ImmutableList<ClassFile.TypeAnnotationInfo> classTypeAnnotations(SourceTypeBoundClass info) {
        ImmutableList.Builder result = ImmutableList.builder();
        if (info.superClassType() != null) {
            this.lowerTypeAnnotations((ImmutableList.Builder<ClassFile.TypeAnnotationInfo>)result, info.superClassType(), ClassFile.TypeAnnotationInfo.TargetType.SUPERTYPE, new ClassFile.TypeAnnotationInfo.SuperTypeTarget(-1));
        }
        int idx = 0;
        for (Type i : info.interfaceTypes()) {
            this.lowerTypeAnnotations((ImmutableList.Builder<ClassFile.TypeAnnotationInfo>)result, i, ClassFile.TypeAnnotationInfo.TargetType.SUPERTYPE, new ClassFile.TypeAnnotationInfo.SuperTypeTarget(idx++));
        }
        this.typeParameterAnnotations((ImmutableList.Builder<ClassFile.TypeAnnotationInfo>)result, (Iterable<TypeBoundClass.TyVarInfo>)info.typeParameterTypes().values(), ClassFile.TypeAnnotationInfo.TargetType.CLASS_TYPE_PARAMETER, ClassFile.TypeAnnotationInfo.TargetType.CLASS_TYPE_PARAMETER_BOUND);
        return result.build();
    }

    private ImmutableList<ClassFile.TypeAnnotationInfo> methodTypeAnnotations(TypeBoundClass.MethodInfo m) {
        ImmutableList.Builder result = ImmutableList.builder();
        this.typeParameterAnnotations((ImmutableList.Builder<ClassFile.TypeAnnotationInfo>)result, (Iterable<TypeBoundClass.TyVarInfo>)m.tyParams().values(), ClassFile.TypeAnnotationInfo.TargetType.METHOD_TYPE_PARAMETER, ClassFile.TypeAnnotationInfo.TargetType.METHOD_TYPE_PARAMETER_BOUND);
        int idx = 0;
        for (Type e : m.exceptions()) {
            this.lowerTypeAnnotations((ImmutableList.Builder<ClassFile.TypeAnnotationInfo>)result, e, ClassFile.TypeAnnotationInfo.TargetType.METHOD_THROWS, new ClassFile.TypeAnnotationInfo.ThrowsTarget(idx++));
        }
        if (m.receiver() != null) {
            this.lowerTypeAnnotations((ImmutableList.Builder<ClassFile.TypeAnnotationInfo>)result, m.receiver().type(), ClassFile.TypeAnnotationInfo.TargetType.METHOD_RECEIVER_PARAMETER, ClassFile.TypeAnnotationInfo.EMPTY_TARGET);
        }
        this.lowerTypeAnnotations((ImmutableList.Builder<ClassFile.TypeAnnotationInfo>)result, m.returnType(), ClassFile.TypeAnnotationInfo.TargetType.METHOD_RETURN, ClassFile.TypeAnnotationInfo.EMPTY_TARGET);
        idx = 0;
        for (TypeBoundClass.ParamInfo p : m.parameters()) {
            if (p.synthetic()) continue;
            this.lowerTypeAnnotations((ImmutableList.Builder<ClassFile.TypeAnnotationInfo>)result, p.type(), ClassFile.TypeAnnotationInfo.TargetType.METHOD_FORMAL_PARAMETER, new ClassFile.TypeAnnotationInfo.FormalParameterTarget(idx++));
        }
        return result.build();
    }

    private void typeParameterAnnotations(ImmutableList.Builder<ClassFile.TypeAnnotationInfo> result, Iterable<TypeBoundClass.TyVarInfo> typeParameters, ClassFile.TypeAnnotationInfo.TargetType targetType, ClassFile.TypeAnnotationInfo.TargetType boundTargetType) {
        int typeParameterIndex = 0;
        for (TypeBoundClass.TyVarInfo p : typeParameters) {
            for (AnnoInfo anno : DisambiguateTypeAnnotations.groupRepeated(this.env, p.annotations())) {
                ClassFile.AnnotationInfo info = this.lowerAnnotation(anno);
                if (info == null) continue;
                result.add((Object)new ClassFile.TypeAnnotationInfo(targetType, new ClassFile.TypeAnnotationInfo.TypeParameterTarget(typeParameterIndex), ClassFile.TypeAnnotationInfo.TypePath.root(), info));
            }
            if (p.superClassBound() != null) {
                this.lowerTypeAnnotations(result, p.superClassBound(), boundTargetType, new ClassFile.TypeAnnotationInfo.TypeParameterBoundTarget(typeParameterIndex, 0));
            }
            int boundIndex = 1;
            for (Type i : p.interfaceBounds()) {
                this.lowerTypeAnnotations(result, i, boundTargetType, new ClassFile.TypeAnnotationInfo.TypeParameterBoundTarget(typeParameterIndex, boundIndex++));
            }
            ++typeParameterIndex;
        }
    }

    private void lowerTypeAnnotations(ImmutableList.Builder<ClassFile.TypeAnnotationInfo> result, Type type, ClassFile.TypeAnnotationInfo.TargetType targetType, ClassFile.TypeAnnotationInfo.Target target) {
        new LowerTypeAnnotations(result, targetType, target).lowerTypeAnnotations(type, ClassFile.TypeAnnotationInfo.TypePath.root());
    }

    class LowerTypeAnnotations {
        private final ImmutableList.Builder<ClassFile.TypeAnnotationInfo> result;
        private final ClassFile.TypeAnnotationInfo.TargetType targetType;
        private final ClassFile.TypeAnnotationInfo.Target target;

        public LowerTypeAnnotations(ImmutableList.Builder<ClassFile.TypeAnnotationInfo> result, ClassFile.TypeAnnotationInfo.TargetType targetType, ClassFile.TypeAnnotationInfo.Target target) {
            this.result = result;
            this.targetType = targetType;
            this.target = target;
        }

        private void lowerTypeAnnotations(Type type, ClassFile.TypeAnnotationInfo.TypePath path) {
            switch (type.tyKind()) {
                case TY_VAR: {
                    this.lowerTypeAnnotations(((Type.TyVar)type).annos(), path);
                    break;
                }
                case CLASS_TY: {
                    this.lowerClassTypeTypeAnnotations((Type.ClassTy)type, path);
                    break;
                }
                case ARRAY_TY: {
                    this.lowerArrayTypeAnnotations(type, path);
                    break;
                }
                case WILD_TY: {
                    this.lowerWildTyTypeAnnotations((Type.WildTy)type, path);
                    break;
                }
                case PRIM_TY: {
                    this.lowerTypeAnnotations(((Type.PrimTy)type).annos(), path);
                    break;
                }
                case VOID_TY: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)type.tyKind());
                }
            }
        }

        private void lowerTypeAnnotations(ImmutableList<AnnoInfo> annos, ClassFile.TypeAnnotationInfo.TypePath path) {
            for (AnnoInfo anno : DisambiguateTypeAnnotations.groupRepeated(Lower.this.env, annos)) {
                ClassFile.AnnotationInfo info = Lower.this.lowerAnnotation(anno);
                if (info == null) continue;
                this.result.add((Object)new ClassFile.TypeAnnotationInfo(this.targetType, this.target, path, info));
            }
        }

        private void lowerWildTyTypeAnnotations(Type.WildTy type, ClassFile.TypeAnnotationInfo.TypePath path) {
            switch (type.boundKind()) {
                case NONE: {
                    this.lowerTypeAnnotations(type.annotations(), path);
                    break;
                }
                case UPPER: 
                case LOWER: {
                    this.lowerTypeAnnotations(type.annotations(), path);
                    this.lowerTypeAnnotations(type.bound(), path.wild());
                    break;
                }
                default: {
                    throw new AssertionError((Object)type.boundKind());
                }
            }
        }

        private void lowerArrayTypeAnnotations(Type type, ClassFile.TypeAnnotationInfo.TypePath path) {
            Type base = type;
            ArrayDeque<Type.ArrayTy> flat = new ArrayDeque<Type.ArrayTy>();
            while (base instanceof Type.ArrayTy) {
                Type.ArrayTy arrayTy = (Type.ArrayTy)base;
                flat.addFirst(arrayTy);
                base = arrayTy.elementType();
            }
            for (Type.ArrayTy arrayTy : flat) {
                this.lowerTypeAnnotations(arrayTy.annos(), path);
                path = path.array();
            }
            this.lowerTypeAnnotations(base, path);
        }

        private void lowerClassTypeTypeAnnotations(Type.ClassTy type, ClassFile.TypeAnnotationInfo.TypePath path) {
            for (Type.ClassTy.SimpleClassTy simple : type.classes) {
                this.lowerTypeAnnotations(simple.annos(), path);
                int idx = 0;
                for (Type a : simple.targs()) {
                    this.lowerTypeAnnotations(a, path.typeArgument(idx++));
                }
                path = path.nested();
            }
        }
    }

    class TyVarEnv
    implements Function<TyVarSymbol, TypeBoundClass.TyVarInfo> {
        private final Map<TyVarSymbol, TypeBoundClass.TyVarInfo> tyParams;

        public TyVarEnv(Map<TyVarSymbol, TypeBoundClass.TyVarInfo> tyParams) {
            this.tyParams = tyParams;
        }

        public TypeBoundClass.TyVarInfo apply(TyVarSymbol sym) {
            TypeBoundClass.TyVarInfo result = this.tyParams.get(sym);
            if (result != null) {
                return result;
            }
            Symbol ownerSym = sym.owner();
            if (ownerSym.symKind() != Symbol.Kind.CLASS) {
                throw new AssertionError(sym);
            }
            TypeBoundClass owner = (TypeBoundClass)Lower.this.env.get((ClassSymbol)ownerSym);
            return (TypeBoundClass.TyVarInfo)owner.typeParameterTypes().get((Object)sym);
        }
    }

    public static class Lowered {
        private final ImmutableMap<String, byte[]> bytes;
        private final ImmutableSet<ClassSymbol> symbols;

        public Lowered(ImmutableMap<String, byte[]> bytes, ImmutableSet<ClassSymbol> symbols) {
            this.bytes = bytes;
            this.symbols = symbols;
        }

        public ImmutableMap<String, byte[]> bytes() {
            return this.bytes;
        }

        public ImmutableSet<ClassSymbol> symbols() {
            return this.symbols;
        }
    }
}

