/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.collectionincompatibletype;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.CompatibleWith;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import java.util.ArrayList;
import java.util.Set;

@BugPattern(name="CompatibleWithAnnotationMisuse", summary="@CompatibleWith's value is not a type argument.", explanation="The `@CompatibleWith` annotation is used to mark parameters that need extra type checking on arguments passed to the method. The annotation was not appropriately placed on a parameter with a valid type argument. See the javadoc for more details.", severity=BugPattern.SeverityLevel.ERROR, category=BugPattern.Category.JDK)
public class CompatibleWithMisuse
extends BugChecker
implements BugChecker.AnnotationTreeMatcher {
    private static final Matcher<AnnotationTree> IS_COMPATIBLE_WITH_ANNOTATION = Matchers.isType((String)CompatibleWith.class.getCanonicalName());

    public Description matchAnnotation(AnnotationTree annoTree, VisitorState state) {
        if (!IS_COMPATIBLE_WITH_ANNOTATION.matches((Tree)annoTree, state)) {
            return Description.NO_MATCH;
        }
        MethodTree methodTree = (MethodTree)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), MethodTree.class);
        VariableTree paramTree = (VariableTree)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), VariableTree.class);
        Symbol.MethodSymbol declaredMethod = ASTHelpers.getSymbol((MethodTree)methodTree);
        if (declaredMethod.isVarArgs() && Iterables.getLast(methodTree.getParameters()) == paramTree) {
            return this.describeWithMessage(annoTree, "@CompatibleWith can't be used on a varargs parameter");
        }
        for (Symbol.MethodSymbol methodSymbol : ASTHelpers.findSuperMethods((Symbol.MethodSymbol)declaredMethod, (Types)state.getTypes())) {
            if (!methodSymbol.params().stream().anyMatch(p -> ASTHelpers.hasAnnotation((Symbol)p, CompatibleWith.class, (VisitorState)state))) continue;
            return this.describeWithMessage(annoTree, String.format("This method overrides a method in %s that already has @CompatibleWith", methodSymbol.owner.getSimpleName()));
        }
        ArrayList potentialTypeVars = new ArrayList(declaredMethod.getTypeParameters());
        Symbol.ClassSymbol cs = (Symbol.ClassSymbol)declaredMethod.owner;
        do {
            potentialTypeVars.addAll(cs.getTypeParameters());
        } while ((cs = cs.isInner() ? cs.owner.enclClass() : null) != null);
        if (potentialTypeVars.isEmpty()) {
            return this.describeWithMessage(annoTree, "There are no type arguments in scope to match against.");
        }
        Set validNames = (Set)potentialTypeVars.stream().map(Symbol::getSimpleName).map(Object::toString).collect(ImmutableSet.toImmutableSet());
        String constValue = this.valueArgumentFromCompatibleWithAnnotation(annoTree);
        if (constValue == null || constValue.isEmpty()) {
            return this.describeWithMessage(annoTree, String.format("The value of @CompatibleWith must not be empty (valid arguments are %s)", this.printTypeArgs(validNames)));
        }
        return validNames.contains(constValue) ? Description.NO_MATCH : this.describeWithMessage(annoTree, String.format("%s is not a valid type argument. Valid arguments are: %s", constValue, this.printTypeArgs(validNames)));
    }

    private String valueArgumentFromCompatibleWithAnnotation(AnnotationTree tree) {
        ExpressionTree argumentValue = (ExpressionTree)Iterables.getOnlyElement(tree.getArguments());
        if (argumentValue.getKind() != Tree.Kind.ASSIGNMENT) {
            return null;
        }
        return (String)ASTHelpers.constValue((Tree)((AssignmentTree)argumentValue).getExpression(), String.class);
    }

    private String printTypeArgs(Set<String> validNames) {
        return Joiner.on((String)", ").join(validNames);
    }

    private Description describeWithMessage(Tree tree, String message) {
        return this.buildDescription(tree).setMessage(message).build();
    }
}

