/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.misc.Unsafe;

final class UnsafeUtil {
    private static final Logger logger = Logger.getLogger(UnsafeUtil.class.getName());
    private static final Unsafe UNSAFE = UnsafeUtil.getUnsafe();
    private static final MemoryAccessor MEMORY_ACCESSOR = UnsafeUtil.getMemoryAccessor();
    private static final boolean HAS_UNSAFE_BYTEBUFFER_OPERATIONS = UnsafeUtil.supportsUnsafeByteBufferOperations();
    private static final boolean HAS_UNSAFE_ARRAY_OPERATIONS = UnsafeUtil.supportsUnsafeArrayOperations();
    private static final long BYTE_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(byte[].class);
    private static final long BOOLEAN_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(boolean[].class);
    private static final long BOOLEAN_ARRAY_INDEX_SCALE = UnsafeUtil.arrayIndexScale(boolean[].class);
    private static final long INT_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(int[].class);
    private static final long INT_ARRAY_INDEX_SCALE = UnsafeUtil.arrayIndexScale(int[].class);
    private static final long LONG_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(long[].class);
    private static final long LONG_ARRAY_INDEX_SCALE = UnsafeUtil.arrayIndexScale(long[].class);
    private static final long FLOAT_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(float[].class);
    private static final long FLOAT_ARRAY_INDEX_SCALE = UnsafeUtil.arrayIndexScale(float[].class);
    private static final long DOUBLE_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(double[].class);
    private static final long DOUBLE_ARRAY_INDEX_SCALE = UnsafeUtil.arrayIndexScale(double[].class);
    private static final long OBJECT_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(Object[].class);
    private static final long OBJECT_ARRAY_INDEX_SCALE = UnsafeUtil.arrayIndexScale(Object[].class);
    private static final long BUFFER_ADDRESS_OFFSET = UnsafeUtil.fieldOffset(UnsafeUtil.bufferAddressField());

    private UnsafeUtil() {
    }

    static boolean hasUnsafeArrayOperations() {
        return HAS_UNSAFE_ARRAY_OPERATIONS;
    }

    static boolean hasUnsafeByteBufferOperations() {
        return HAS_UNSAFE_BYTEBUFFER_OPERATIONS;
    }

    static long objectFieldOffset(Field field) {
        return MEMORY_ACCESSOR.objectFieldOffset(field);
    }

    private static int arrayBaseOffset(Class<?> clazz) {
        return HAS_UNSAFE_ARRAY_OPERATIONS ? MEMORY_ACCESSOR.arrayBaseOffset(clazz) : -1;
    }

    private static int arrayIndexScale(Class<?> clazz) {
        return HAS_UNSAFE_ARRAY_OPERATIONS ? MEMORY_ACCESSOR.arrayIndexScale(clazz) : -1;
    }

    static byte getByte(Object object, long l) {
        return MEMORY_ACCESSOR.getByte(object, l);
    }

    static void putByte(Object object, long l, byte by) {
        MEMORY_ACCESSOR.putByte(object, l, by);
    }

    static int getInt(Object object, long l) {
        return MEMORY_ACCESSOR.getInt(object, l);
    }

    static void putInt(Object object, long l, int n) {
        MEMORY_ACCESSOR.putInt(object, l, n);
    }

    static long getLong(Object object, long l) {
        return MEMORY_ACCESSOR.getLong(object, l);
    }

    static void putLong(Object object, long l, long l2) {
        MEMORY_ACCESSOR.putLong(object, l, l2);
    }

    static boolean getBoolean(Object object, long l) {
        return MEMORY_ACCESSOR.getBoolean(object, l);
    }

    static void putBoolean(Object object, long l, boolean bl) {
        MEMORY_ACCESSOR.putBoolean(object, l, bl);
    }

    static float getFloat(Object object, long l) {
        return MEMORY_ACCESSOR.getFloat(object, l);
    }

    static void putFloat(Object object, long l, float f) {
        MEMORY_ACCESSOR.putFloat(object, l, f);
    }

    static double getDouble(Object object, long l) {
        return MEMORY_ACCESSOR.getDouble(object, l);
    }

    static void putDouble(Object object, long l, double d) {
        MEMORY_ACCESSOR.putDouble(object, l, d);
    }

    static Object getObject(Object object, long l) {
        return MEMORY_ACCESSOR.getObject(object, l);
    }

    static void putObject(Object object, long l, Object object2) {
        MEMORY_ACCESSOR.putObject(object, l, object2);
    }

    static byte getByte(byte[] byArray, long l) {
        return MEMORY_ACCESSOR.getByte(byArray, BYTE_ARRAY_BASE_OFFSET + l);
    }

    static void putByte(byte[] byArray, long l, byte by) {
        MEMORY_ACCESSOR.putByte(byArray, BYTE_ARRAY_BASE_OFFSET + l, by);
    }

    static int getInt(int[] nArray, long l) {
        return MEMORY_ACCESSOR.getInt(nArray, INT_ARRAY_BASE_OFFSET + l * INT_ARRAY_INDEX_SCALE);
    }

    static void putInt(int[] nArray, long l, int n) {
        MEMORY_ACCESSOR.putInt(nArray, INT_ARRAY_BASE_OFFSET + l * INT_ARRAY_INDEX_SCALE, n);
    }

    static long getLong(long[] lArray, long l) {
        return MEMORY_ACCESSOR.getLong(lArray, LONG_ARRAY_BASE_OFFSET + l * LONG_ARRAY_INDEX_SCALE);
    }

    static void putLong(long[] lArray, long l, long l2) {
        MEMORY_ACCESSOR.putLong(lArray, LONG_ARRAY_BASE_OFFSET + l * LONG_ARRAY_INDEX_SCALE, l2);
    }

    static boolean getBoolean(boolean[] blArray, long l) {
        return MEMORY_ACCESSOR.getBoolean(blArray, BOOLEAN_ARRAY_BASE_OFFSET + l * BOOLEAN_ARRAY_INDEX_SCALE);
    }

    static void putBoolean(boolean[] blArray, long l, boolean bl) {
        MEMORY_ACCESSOR.putBoolean(blArray, BOOLEAN_ARRAY_BASE_OFFSET + l * BOOLEAN_ARRAY_INDEX_SCALE, bl);
    }

    static float getFloat(float[] fArray, long l) {
        return MEMORY_ACCESSOR.getFloat(fArray, FLOAT_ARRAY_BASE_OFFSET + l * FLOAT_ARRAY_INDEX_SCALE);
    }

    static void putFloat(float[] fArray, long l, float f) {
        MEMORY_ACCESSOR.putFloat(fArray, FLOAT_ARRAY_BASE_OFFSET + l * FLOAT_ARRAY_INDEX_SCALE, f);
    }

    static double getDouble(double[] dArray, long l) {
        return MEMORY_ACCESSOR.getDouble(dArray, DOUBLE_ARRAY_BASE_OFFSET + l * DOUBLE_ARRAY_INDEX_SCALE);
    }

    static void putDouble(double[] dArray, long l, double d) {
        MEMORY_ACCESSOR.putDouble(dArray, DOUBLE_ARRAY_BASE_OFFSET + l * DOUBLE_ARRAY_INDEX_SCALE, d);
    }

    static Object getObject(Object[] objectArray, long l) {
        return MEMORY_ACCESSOR.getObject(objectArray, OBJECT_ARRAY_BASE_OFFSET + l * OBJECT_ARRAY_INDEX_SCALE);
    }

    static void putObject(Object[] objectArray, long l, Object object) {
        MEMORY_ACCESSOR.putObject(objectArray, OBJECT_ARRAY_BASE_OFFSET + l * OBJECT_ARRAY_INDEX_SCALE, object);
    }

    static void copyMemory(byte[] byArray, long l, long l2, long l3) {
        MEMORY_ACCESSOR.copyMemory(byArray, l, l2, l3);
    }

    static void copyMemory(long l, byte[] byArray, long l2, long l3) {
        MEMORY_ACCESSOR.copyMemory(l, byArray, l2, l3);
    }

    static void copyMemory(byte[] byArray, long l, byte[] byArray2, long l2, long l3) {
        System.arraycopy(byArray, (int)l, byArray2, (int)l2, (int)l3);
    }

    static byte getByte(long l) {
        return MEMORY_ACCESSOR.getByte(l);
    }

    static void putByte(long l, byte by) {
        MEMORY_ACCESSOR.putByte(l, by);
    }

    static int getInt(long l) {
        return MEMORY_ACCESSOR.getInt(l);
    }

    static void putInt(long l, int n) {
        MEMORY_ACCESSOR.putInt(l, n);
    }

    static long getLong(long l) {
        return MEMORY_ACCESSOR.getLong(l);
    }

    static void putLong(long l, long l2) {
        MEMORY_ACCESSOR.putLong(l, l2);
    }

    static void copyMemory(long l, long l2, long l3) {
        MEMORY_ACCESSOR.copyMemory(l, l2, l3);
    }

    static long addressOffset(ByteBuffer byteBuffer) {
        return MEMORY_ACCESSOR.getLong(byteBuffer, BUFFER_ADDRESS_OFFSET);
    }

    static Object getStaticObject(Field field) {
        return MEMORY_ACCESSOR.getStaticObject(field);
    }

    private static Unsafe getUnsafe() {
        Unsafe unsafe = null;
        try {
            unsafe = AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                @Override
                public Unsafe run() throws Exception {
                    Class<Unsafe> clazz = Unsafe.class;
                    for (Field field : clazz.getDeclaredFields()) {
                        field.setAccessible(true);
                        Object object = field.get(null);
                        if (!clazz.isInstance(object)) continue;
                        return (Unsafe)clazz.cast(object);
                    }
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return unsafe;
    }

    private static MemoryAccessor getMemoryAccessor() {
        if (UNSAFE == null) {
            return null;
        }
        return new JvmMemoryAccessor(UNSAFE);
    }

    private static boolean supportsUnsafeArrayOperations() {
        if (UNSAFE == null) {
            return false;
        }
        try {
            Class<?> clazz = UNSAFE.getClass();
            clazz.getMethod("objectFieldOffset", Field.class);
            clazz.getMethod("arrayBaseOffset", Class.class);
            clazz.getMethod("arrayIndexScale", Class.class);
            clazz.getMethod("getInt", Object.class, Long.TYPE);
            clazz.getMethod("putInt", Object.class, Long.TYPE, Integer.TYPE);
            clazz.getMethod("getLong", Object.class, Long.TYPE);
            clazz.getMethod("putLong", Object.class, Long.TYPE, Long.TYPE);
            clazz.getMethod("getObject", Object.class, Long.TYPE);
            clazz.getMethod("putObject", Object.class, Long.TYPE, Object.class);
            clazz.getMethod("getByte", Object.class, Long.TYPE);
            clazz.getMethod("putByte", Object.class, Long.TYPE, Byte.TYPE);
            clazz.getMethod("getBoolean", Object.class, Long.TYPE);
            clazz.getMethod("putBoolean", Object.class, Long.TYPE, Boolean.TYPE);
            clazz.getMethod("getFloat", Object.class, Long.TYPE);
            clazz.getMethod("putFloat", Object.class, Long.TYPE, Float.TYPE);
            clazz.getMethod("getDouble", Object.class, Long.TYPE);
            clazz.getMethod("putDouble", Object.class, Long.TYPE, Double.TYPE);
            return true;
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, "platform method missing - proto runtime falling back to safer methods: " + throwable);
            return false;
        }
    }

    private static boolean supportsUnsafeByteBufferOperations() {
        if (UNSAFE == null) {
            return false;
        }
        try {
            Class<?> clazz = UNSAFE.getClass();
            clazz.getMethod("objectFieldOffset", Field.class);
            clazz.getMethod("getLong", Object.class, Long.TYPE);
            clazz.getMethod("getByte", Long.TYPE);
            clazz.getMethod("putByte", Long.TYPE, Byte.TYPE);
            clazz.getMethod("getInt", Long.TYPE);
            clazz.getMethod("putInt", Long.TYPE, Integer.TYPE);
            clazz.getMethod("getLong", Long.TYPE);
            clazz.getMethod("putLong", Long.TYPE, Long.TYPE);
            clazz.getMethod("copyMemory", Long.TYPE, Long.TYPE, Long.TYPE);
            clazz.getMethod("copyMemory", Object.class, Long.TYPE, Object.class, Long.TYPE, Long.TYPE);
            return true;
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, "platform method missing - proto runtime falling back to safer methods: " + throwable);
            return false;
        }
    }

    private static <T> Class<T> getClassForName(String string) {
        try {
            return Class.forName(string);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Field bufferAddressField() {
        return UnsafeUtil.field(Buffer.class, "address");
    }

    private static long fieldOffset(Field field) {
        return field == null || MEMORY_ACCESSOR == null ? -1L : MEMORY_ACCESSOR.objectFieldOffset(field);
    }

    private static Field field(Class<?> clazz, String string) {
        Field field;
        try {
            field = clazz.getDeclaredField(string);
            field.setAccessible(true);
        }
        catch (Throwable throwable) {
            field = null;
        }
        return field;
    }

    private static final class JvmMemoryAccessor
    extends MemoryAccessor {
        JvmMemoryAccessor(Unsafe unsafe) {
            super(unsafe);
        }

        @Override
        public byte getByte(long l) {
            return this.unsafe.getByte(l);
        }

        @Override
        public void putByte(long l, byte by) {
            this.unsafe.putByte(l, by);
        }

        @Override
        public int getInt(long l) {
            return this.unsafe.getInt(l);
        }

        @Override
        public void putInt(long l, int n) {
            this.unsafe.putInt(l, n);
        }

        @Override
        public long getLong(long l) {
            return this.unsafe.getLong(l);
        }

        @Override
        public void putLong(long l, long l2) {
            this.unsafe.putLong(l, l2);
        }

        @Override
        public byte getByte(Object object, long l) {
            return this.unsafe.getByte(object, l);
        }

        @Override
        public void putByte(Object object, long l, byte by) {
            this.unsafe.putByte(object, l, by);
        }

        @Override
        public boolean getBoolean(Object object, long l) {
            return this.unsafe.getBoolean(object, l);
        }

        @Override
        public void putBoolean(Object object, long l, boolean bl) {
            this.unsafe.putBoolean(object, l, bl);
        }

        @Override
        public float getFloat(Object object, long l) {
            return this.unsafe.getFloat(object, l);
        }

        @Override
        public void putFloat(Object object, long l, float f) {
            this.unsafe.putFloat(object, l, f);
        }

        @Override
        public double getDouble(Object object, long l) {
            return this.unsafe.getDouble(object, l);
        }

        @Override
        public void putDouble(Object object, long l, double d) {
            this.unsafe.putDouble(object, l, d);
        }

        @Override
        public void copyMemory(long l, long l2, long l3) {
            this.unsafe.copyMemory(l, l2, l3);
        }

        @Override
        public void copyMemory(long l, byte[] byArray, long l2, long l3) {
            this.unsafe.copyMemory(null, l, byArray, BYTE_ARRAY_BASE_OFFSET + l2, l3);
        }

        @Override
        public void copyMemory(byte[] byArray, long l, long l2, long l3) {
            this.unsafe.copyMemory(byArray, BYTE_ARRAY_BASE_OFFSET + l, null, l2, l3);
        }

        @Override
        public Object getStaticObject(Field field) {
            return this.getObject(this.unsafe.staticFieldBase(field), this.unsafe.staticFieldOffset(field));
        }
    }

    private static abstract class MemoryAccessor {
        Unsafe unsafe;

        MemoryAccessor(Unsafe unsafe) {
            this.unsafe = unsafe;
        }

        public final long objectFieldOffset(Field field) {
            return this.unsafe.objectFieldOffset(field);
        }

        public abstract byte getByte(Object var1, long var2);

        public abstract void putByte(Object var1, long var2, byte var4);

        public final int getInt(Object object, long l) {
            return this.unsafe.getInt(object, l);
        }

        public final void putInt(Object object, long l, int n) {
            this.unsafe.putInt(object, l, n);
        }

        public final long getLong(Object object, long l) {
            return this.unsafe.getLong(object, l);
        }

        public final void putLong(Object object, long l, long l2) {
            this.unsafe.putLong(object, l, l2);
        }

        public abstract boolean getBoolean(Object var1, long var2);

        public abstract void putBoolean(Object var1, long var2, boolean var4);

        public abstract float getFloat(Object var1, long var2);

        public abstract void putFloat(Object var1, long var2, float var4);

        public abstract double getDouble(Object var1, long var2);

        public abstract void putDouble(Object var1, long var2, double var4);

        public final Object getObject(Object object, long l) {
            return this.unsafe.getObject(object, l);
        }

        public final void putObject(Object object, long l, Object object2) {
            this.unsafe.putObject(object, l, object2);
        }

        public final int arrayBaseOffset(Class<?> clazz) {
            return this.unsafe.arrayBaseOffset(clazz);
        }

        public final int arrayIndexScale(Class<?> clazz) {
            return this.unsafe.arrayIndexScale(clazz);
        }

        public abstract byte getByte(long var1);

        public abstract void putByte(long var1, byte var3);

        public abstract int getInt(long var1);

        public abstract void putInt(long var1, int var3);

        public abstract long getLong(long var1);

        public abstract void putLong(long var1, long var3);

        public abstract void copyMemory(long var1, long var3, long var5);

        public abstract Object getStaticObject(Field var1);

        public abstract void copyMemory(long var1, byte[] var3, long var4, long var6);

        public abstract void copyMemory(byte[] var1, long var2, long var4, long var6);
    }
}

