/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.node;

import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.dataflow.util.HashCodeUtils;

public class ArrayCreationNode
extends Node {
    protected final NewArrayTree tree;
    protected final List<Node> dimensions;
    protected final List<Node> initializers;

    public ArrayCreationNode(NewArrayTree tree, TypeMirror type, List<Node> dimensions, List<Node> initializers) {
        super(type);
        this.tree = tree;
        this.dimensions = dimensions;
        this.initializers = initializers;
    }

    public List<Node> getDimensions() {
        return this.dimensions;
    }

    public Node getDimension(int i) {
        return this.dimensions.get(i);
    }

    public List<Node> getInitializers() {
        return this.initializers;
    }

    public Node getInitializer(int i) {
        return this.initializers.get(i);
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitArrayCreation(this, p);
    }

    public String toString() {
        boolean needComma;
        StringBuilder sb = new StringBuilder();
        sb.append("new " + this.type);
        if (!this.dimensions.isEmpty()) {
            needComma = false;
            sb.append(" (");
            for (Node dim : this.dimensions) {
                if (needComma) {
                    sb.append(", ");
                }
                sb.append(dim);
                needComma = true;
            }
            sb.append(")");
        }
        if (!this.initializers.isEmpty()) {
            needComma = false;
            sb.append(" = {");
            for (Node init : this.initializers) {
                if (needComma) {
                    sb.append(", ");
                }
                sb.append(init);
                needComma = true;
            }
            sb.append("}");
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ArrayCreationNode)) {
            return false;
        }
        ArrayCreationNode other = (ArrayCreationNode)obj;
        return this.getDimensions().equals(other.getDimensions()) && this.getInitializers().equals(other.getInitializers());
    }

    public int hashCode() {
        int hash = 0;
        for (Node dim : this.dimensions) {
            hash = HashCodeUtils.hash(hash, dim.hashCode());
        }
        for (Node init : this.initializers) {
            hash = HashCodeUtils.hash(hash, init.hashCode());
        }
        return hash;
    }

    @Override
    public Collection<Node> getOperands() {
        ArrayList<Node> list = new ArrayList<Node>(this.dimensions.size() + this.initializers.size());
        list.addAll(this.dimensions);
        list.addAll(this.initializers);
        return list;
    }
}

