/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization.autocodec;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.AutoCodecUtil;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.SerializationCodeGenerator;
import com.google.devtools.build.lib.skyframe.serialization.strings.StringCodecs;
import com.squareup.javapoet.TypeName;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;

class Marshallers {
    private final ProcessingEnvironment env;
    private final SerializationCodeGenerator arrayCodeGenerator = new SerializationCodeGenerator(){

        @Override
        public void addSerializationCode(SerializationCodeGenerator.Context context) {
            String length = context.makeName("length");
            context.builder.addStatement("int $L = $L.length", new Object[]{length, context.name});
            context.builder.addStatement("codedOut.writeInt32NoTag($L)", new Object[]{length});
            SerializationCodeGenerator.Context repeated = context.with(((ArrayType)context.type).getComponentType(), context.makeName("repeated"));
            String indexName = context.makeName("i");
            context.builder.beginControlFlow("for(int $L = 0; $L < $L; ++$L)", new Object[]{indexName, indexName, length, indexName});
            context.builder.addStatement("$T $L = $L[$L]", new Object[]{repeated.getTypeName(), repeated.name, context.name, indexName});
            Marshallers.this.writeSerializationCode(repeated);
            context.builder.endControlFlow();
        }

        @Override
        public void addDeserializationCode(SerializationCodeGenerator.Context context) {
            SerializationCodeGenerator.Context repeated = context.with(((ArrayType)context.type).getComponentType(), context.makeName("repeated"));
            String lengthName = context.makeName("length");
            context.builder.addStatement("int $L = codedIn.readInt32()", new Object[]{lengthName});
            String resultName = context.makeName("result");
            context.builder.addStatement("$T[] $L = new $T[$L]", new Object[]{repeated.getTypeName(), resultName, repeated.getTypeName(), lengthName});
            String indexName = context.makeName("i");
            context.builder.beginControlFlow("for (int $L = 0; $L < $L; ++$L)", new Object[]{indexName, indexName, lengthName, indexName});
            Marshallers.this.writeDeserializationCode(repeated);
            context.builder.addStatement("$L[$L] = $L", new Object[]{resultName, indexName, repeated.name});
            context.builder.endControlFlow();
            context.builder.addStatement("$L = $L", new Object[]{context.name, resultName});
        }
    };
    private static final SerializationCodeGenerator.PrimitiveValueSerializationCodeGenerator INT_CODE_GENERATOR = new SerializationCodeGenerator.PrimitiveValueSerializationCodeGenerator(){

        @Override
        public boolean matches(PrimitiveType type) {
            return type.getKind() == TypeKind.INT;
        }

        @Override
        public void addSerializationCode(SerializationCodeGenerator.Context context) {
            context.builder.addStatement("codedOut.writeInt32NoTag($L)", new Object[]{context.name});
        }

        @Override
        public void addDeserializationCode(SerializationCodeGenerator.Context context) {
            context.builder.addStatement("$L = codedIn.readInt32()", new Object[]{context.name});
        }
    };
    private static final SerializationCodeGenerator.PrimitiveValueSerializationCodeGenerator LONG_CODE_GENERATOR = new SerializationCodeGenerator.PrimitiveValueSerializationCodeGenerator(){

        @Override
        public boolean matches(PrimitiveType type) {
            return type.getKind() == TypeKind.LONG;
        }

        @Override
        public void addSerializationCode(SerializationCodeGenerator.Context context) {
            context.builder.addStatement("codedOut.writeInt64NoTag($L)", new Object[]{context.name});
        }

        @Override
        public void addDeserializationCode(SerializationCodeGenerator.Context context) {
            context.builder.addStatement("$L = codedIn.readInt64()", new Object[]{context.name});
        }
    };
    private static final SerializationCodeGenerator.PrimitiveValueSerializationCodeGenerator BYTE_CODE_GENERATOR = new SerializationCodeGenerator.PrimitiveValueSerializationCodeGenerator(){

        @Override
        public boolean matches(PrimitiveType type) {
            return type.getKind() == TypeKind.BYTE;
        }

        @Override
        public void addSerializationCode(SerializationCodeGenerator.Context context) {
            context.builder.addStatement("codedOut.write($L)", new Object[]{context.name});
        }

        @Override
        public void addDeserializationCode(SerializationCodeGenerator.Context context) {
            context.builder.addStatement("$L = codedIn.readRawByte()", new Object[]{context.name});
        }
    };
    private static final SerializationCodeGenerator.PrimitiveValueSerializationCodeGenerator BOOLEAN_CODE_GENERATOR = new SerializationCodeGenerator.PrimitiveValueSerializationCodeGenerator(){

        @Override
        public boolean matches(PrimitiveType type) {
            return type.getKind() == TypeKind.BOOLEAN;
        }

        @Override
        public void addSerializationCode(SerializationCodeGenerator.Context context) {
            context.builder.addStatement("codedOut.writeBoolNoTag($L)", new Object[]{context.name});
        }

        @Override
        public void addDeserializationCode(SerializationCodeGenerator.Context context) {
            context.builder.addStatement("$L = codedIn.readBool()", new Object[]{context.name});
        }
    };
    private static final SerializationCodeGenerator.PrimitiveValueSerializationCodeGenerator DOUBLE_CODE_GENERATOR = new SerializationCodeGenerator.PrimitiveValueSerializationCodeGenerator(){

        @Override
        public boolean matches(PrimitiveType type) {
            return type.getKind() == TypeKind.DOUBLE;
        }

        @Override
        public void addSerializationCode(SerializationCodeGenerator.Context context) {
            context.builder.addStatement("codedOut.writeDoubleNoTag($L)", new Object[]{context.name});
        }

        @Override
        public void addDeserializationCode(SerializationCodeGenerator.Context context) {
            context.builder.addStatement("$L = codedIn.readDouble()", new Object[]{context.name});
        }
    };
    private final SerializationCodeGenerator.Marshaller charSequenceMarshaller = new SerializationCodeGenerator.Marshaller(){

        @Override
        public boolean matches(DeclaredType type) {
            return Marshallers.this.matchesType(type, CharSequence.class);
        }

        @Override
        public void addSerializationCode(SerializationCodeGenerator.Context context) {
            context.builder.addStatement("$T.asciiOptimized().serialize(context, $L.toString(), codedOut)", new Object[]{StringCodecs.class, context.name});
        }

        @Override
        public void addDeserializationCode(SerializationCodeGenerator.Context context) {
            context.builder.addStatement("$L = $T.asciiOptimized().deserialize(context, codedIn)", new Object[]{context.name, StringCodecs.class});
        }
    };
    private final SerializationCodeGenerator.Marshaller supplierMarshaller = new SerializationCodeGenerator.Marshaller(){

        @Override
        public boolean matches(DeclaredType type) {
            return Marshallers.this.matchesErased(type, Supplier.class);
        }

        @Override
        public void addSerializationCode(SerializationCodeGenerator.Context context) {
            DeclaredType suppliedType = (DeclaredType)context.getDeclaredType().getTypeArguments().get(0);
            Marshallers.this.writeSerializationCode(context.with(suppliedType, context.name + ".get()"));
        }

        @Override
        public void addDeserializationCode(SerializationCodeGenerator.Context context) {
            DeclaredType suppliedType = (DeclaredType)context.getDeclaredType().getTypeArguments().get(0);
            String suppliedName = context.makeName("supplied");
            Marshallers.this.writeDeserializationCode(context.with(suppliedType, suppliedName));
            String suppliedFinalName = context.makeName("suppliedFinal");
            context.builder.addStatement("final $T $L = $L", new Object[]{suppliedType, suppliedFinalName, suppliedName});
            context.builder.addStatement("$L = () -> $L", new Object[]{context.name, suppliedFinalName});
        }
    };
    private final SerializationCodeGenerator.Marshaller immutableSortedSetMarshaller = new SerializationCodeGenerator.Marshaller(){

        @Override
        public boolean matches(DeclaredType type) {
            return Marshallers.this.matchesErased(type, ImmutableSortedSet.class);
        }

        @Override
        public void addSerializationCode(SerializationCodeGenerator.Context context) {
            Marshallers.this.addSerializationCodeForIterable(context);
        }

        @Override
        public void addDeserializationCode(SerializationCodeGenerator.Context context) {
            SerializationCodeGenerator.Context repeated = context.with(context.getDeclaredType().getTypeArguments().get(0), context.makeName("repeated"));
            String builderName = context.makeName("builder");
            context.builder.addStatement("$T<$T> $L = new $T<>($T.naturalOrder())", new Object[]{ImmutableSortedSet.Builder.class, repeated.getTypeName(), builderName, ImmutableSortedSet.Builder.class, Comparator.class});
            Marshallers.this.writeIterableDeserializationLoopWithoutNullsAndBuild(context, repeated, builderName);
        }
    };
    private final SerializationCodeGenerator.Marshaller multimapMarshaller = new SerializationCodeGenerator.Marshaller(){

        @Override
        public boolean matches(DeclaredType type) {
            return Marshallers.this.matchesErased(type, ImmutableMultimap.class) || Marshallers.this.matchesErased(type, ImmutableListMultimap.class);
        }

        @Override
        public void addSerializationCode(SerializationCodeGenerator.Context context) {
            context.builder.addStatement("codedOut.writeInt32NoTag($L.size())", new Object[]{context.name});
            String entryName = context.makeName("entry");
            SerializationCodeGenerator.Context key = context.with(context.getDeclaredType().getTypeArguments().get(0), entryName + ".getKey()");
            SerializationCodeGenerator.Context value = context.with(context.getDeclaredType().getTypeArguments().get(1), entryName + ".getValue()");
            context.builder.beginControlFlow("for ($T<$T, $T> $L : $L.entries())", new Object[]{Map.Entry.class, key.getTypeName(), value.getTypeName(), entryName, context.name});
            Marshallers.this.writeSerializationCode(key);
            Marshallers.this.writeSerializationCode(value);
            context.builder.endControlFlow();
        }

        @Override
        public void addDeserializationCode(SerializationCodeGenerator.Context context) {
            SerializationCodeGenerator.Context key = context.with(context.getDeclaredType().getTypeArguments().get(0), context.makeName("key"));
            SerializationCodeGenerator.Context value = context.with(context.getDeclaredType().getTypeArguments().get(1), context.makeName("value"));
            String builderName = context.makeName("builder");
            context.builder.addStatement("$T<$T, $T> $L = new $T<>()", new Object[]{ImmutableListMultimap.Builder.class, key.getTypeName(), value.getTypeName(), builderName, ImmutableListMultimap.Builder.class});
            String lengthName = context.makeName("length");
            context.builder.addStatement("int $L = codedIn.readInt32()", new Object[]{lengthName});
            String indexName = context.makeName("i");
            context.builder.beginControlFlow("for (int $L = 0; $L < $L; ++$L)", new Object[]{indexName, indexName, lengthName, indexName});
            Marshallers.this.writeDeserializationCode(key);
            Marshallers.this.writeDeserializationCode(value);
            context.builder.addStatement("$L.put($L, $L)", new Object[]{builderName, key.name, value.name});
            context.builder.endControlFlow();
            context.builder.addStatement("$L = $L.build()", new Object[]{context.name, builderName});
        }
    };
    private final SerializationCodeGenerator.Marshaller contextMarshaller = new SerializationCodeGenerator.Marshaller(){

        @Override
        public boolean matches(DeclaredType unusedType) {
            return true;
        }

        @Override
        public void addSerializationCode(SerializationCodeGenerator.Context context) {
            context.builder.addStatement("context.serialize($L, codedOut)", new Object[]{context.name});
        }

        @Override
        public void addDeserializationCode(SerializationCodeGenerator.Context context) {
            context.builder.addStatement("$L = context.deserialize(codedIn)", new Object[]{context.name});
        }
    };
    private final ImmutableList<SerializationCodeGenerator.PrimitiveValueSerializationCodeGenerator> primitiveGenerators = ImmutableList.of((Object)INT_CODE_GENERATOR, (Object)LONG_CODE_GENERATOR, (Object)BYTE_CODE_GENERATOR, (Object)BOOLEAN_CODE_GENERATOR, (Object)DOUBLE_CODE_GENERATOR);
    private final ImmutableList<SerializationCodeGenerator.Marshaller> marshallers = ImmutableList.of((Object)this.charSequenceMarshaller, (Object)this.supplierMarshaller, (Object)this.immutableSortedSetMarshaller, (Object)this.multimapMarshaller, (Object)this.contextMarshaller);

    Marshallers(ProcessingEnvironment env) {
        this.env = env;
    }

    void writeSerializationCode(SerializationCodeGenerator.Context context) {
        boolean needsNullHandling;
        SerializationCodeGenerator generator = this.getMatchingCodeGenerator(context.type);
        boolean bl = needsNullHandling = context.canBeNull() && generator != this.contextMarshaller;
        if (needsNullHandling) {
            context.builder.beginControlFlow("if ($L != null)", new Object[]{context.name});
            context.builder.addStatement("codedOut.writeBoolNoTag(true)", new Object[0]);
        }
        generator.addSerializationCode(context);
        if (needsNullHandling) {
            context.builder.nextControlFlow("else", new Object[0]);
            context.builder.addStatement("codedOut.writeBoolNoTag(false)", new Object[0]);
            context.builder.endControlFlow();
        }
    }

    void writeDeserializationCode(SerializationCodeGenerator.Context context) {
        SerializationCodeGenerator generator = this.getMatchingCodeGenerator(context.type);
        boolean needsNullHandling = context.canBeNull() && generator != this.contextMarshaller;
        TypeName contextTypeName = context.getTypeName();
        if (context.isDeclaredType() && !context.getDeclaredType().getTypeArguments().isEmpty()) {
            for (TypeMirror typeMirror : context.getDeclaredType().getTypeArguments()) {
                if (!Marshallers.isVariableOrWildcardType(typeMirror)) continue;
                contextTypeName = TypeName.get((TypeMirror)this.env.getTypeUtils().erasure(context.getDeclaredType()));
            }
        } else if (Marshallers.isVariableOrWildcardType(context.getTypeMirror())) {
            contextTypeName = TypeName.get((TypeMirror)this.env.getTypeUtils().erasure(context.getTypeMirror()));
        }
        if (needsNullHandling) {
            context.builder.addStatement("$T $L = null", new Object[]{contextTypeName, context.name});
            context.builder.beginControlFlow("if (codedIn.readBool())", new Object[0]);
        } else {
            context.builder.addStatement("$T $L", new Object[]{contextTypeName, context.name});
        }
        generator.addDeserializationCode(context);
        if (needsNullHandling) {
            context.builder.endControlFlow();
        }
    }

    private void writeIterableDeserializationLoopWithoutNullsAndBuild(SerializationCodeGenerator.Context context, SerializationCodeGenerator.Context repeated, String builderName) {
        String lengthName = context.makeName("length");
        context.builder.addStatement("int $L = codedIn.readInt32()", new Object[]{lengthName});
        String indexName = context.makeName("i");
        context.builder.beginControlFlow("for (int $L = 0; $L < $L; ++$L)", new Object[]{indexName, indexName, lengthName, indexName});
        this.writeDeserializationCode(repeated);
        context.builder.addStatement("$L.add($L)", new Object[]{builderName, repeated.name});
        context.builder.endControlFlow();
        context.builder.addStatement("$L = $L.build()", new Object[]{context.name, builderName});
    }

    private SerializationCodeGenerator getMatchingCodeGenerator(TypeMirror type) {
        if (type.getKind() == TypeKind.ARRAY) {
            return this.arrayCodeGenerator;
        }
        if (type instanceof PrimitiveType) {
            PrimitiveType primitiveType = (PrimitiveType)type;
            return this.primitiveGenerators.stream().filter(generator -> generator.matches((PrimitiveType)type)).findFirst().orElseThrow(() -> new IllegalArgumentException("No generator for: " + primitiveType));
        }
        if (Marshallers.isVariableOrWildcardType(type)) {
            return this.contextMarshaller;
        }
        if (!(type instanceof DeclaredType)) {
            throw new IllegalArgumentException("Can only serialize primitive, array or declared fields, found " + type);
        }
        DeclaredType declaredType = (DeclaredType)type;
        return this.marshallers.stream().filter(marshaller -> marshaller.matches(declaredType)).findFirst().orElseThrow(() -> new IllegalArgumentException("No marshaller for: " + ((TypeElement)declaredType.asElement()).getQualifiedName()));
    }

    private void addSerializationCodeForIterable(SerializationCodeGenerator.Context context) {
        context.builder.addStatement("codedOut.writeInt32NoTag($T.size($L))", new Object[]{Iterables.class, context.name});
        TypeMirror typeParameter = context.getDeclaredType().getTypeArguments().get(0);
        if (Marshallers.isVariableOrWildcardType(typeParameter)) {
            typeParameter = this.env.getTypeUtils().erasure(typeParameter);
        }
        SerializationCodeGenerator.Context repeated = context.with(context.getDeclaredType().getTypeArguments().get(0), context.makeName("repeated"));
        context.builder.beginControlFlow("for ($T $L : $L)", new Object[]{typeParameter, repeated.name, context.name});
        this.writeSerializationCode(repeated);
        context.builder.endControlFlow();
    }

    private boolean matchesType(TypeMirror type, Class<?> clazz) {
        return this.env.getTypeUtils().isSameType(type, this.getType(clazz));
    }

    private boolean matchesErased(TypeMirror type, Class<?> clazz) {
        return this.env.getTypeUtils().isSameType(this.env.getTypeUtils().erasure(type), this.env.getTypeUtils().erasure(this.getType(clazz)));
    }

    private TypeMirror getType(Class<?> clazz) {
        return AutoCodecUtil.getType(clazz, this.env);
    }

    static boolean isVariableOrWildcardType(TypeMirror type) {
        return type instanceof TypeVariable || type instanceof WildcardType;
    }
}

