/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.query;

import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.query.MapQueryEngine;
import com.hazelcast.map.impl.query.QueryResult;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.query.Predicate;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.spi.ReadonlyOperation;
import com.hazelcast.util.IterationType;
import java.io.IOException;

public class QueryPartitionOperation
extends MapOperation
implements PartitionAwareOperation,
ReadonlyOperation {
    private Predicate predicate;
    private QueryResult result;
    private IterationType iterationType;

    public QueryPartitionOperation() {
    }

    public QueryPartitionOperation(String mapName, Predicate predicate, IterationType iterationType) {
        super(mapName);
        this.predicate = predicate;
        this.iterationType = iterationType;
    }

    @Override
    public void run() {
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        MapQueryEngine queryEngine = mapServiceContext.getMapQueryEngine(this.name);
        this.result = queryEngine.queryLocalPartition(this.name, this.predicate, this.getPartitionId(), this.iterationType);
    }

    @Override
    public Object getResponse() {
        return this.result;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.predicate);
        out.writeByte(this.iterationType.getId());
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.predicate = (Predicate)in.readObject();
        this.iterationType = IterationType.getById(in.readByte());
    }
}

