/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.auto.value.AutoValue;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AutoValue_StaticImports_StaticImportInfo;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;
import javax.annotation.Nullable;

public final class StaticImports {
    @Nullable
    public static StaticImportInfo tryCreate(ImportTree tree, VisitorState state) {
        if (!tree.isStatic()) {
            return null;
        }
        if (!(tree.getQualifiedIdentifier() instanceof JCTree.JCFieldAccess)) {
            return null;
        }
        JCTree.JCFieldAccess access = (JCTree.JCFieldAccess)tree.getQualifiedIdentifier();
        String importedName = access.toString();
        Type result = state.getTypeFromString(importedName);
        if (result == null) {
            return StaticImports.tryAsStaticMember(access, state);
        }
        String canonicalName = state.getTypes().erasure(result).toString();
        if (canonicalName == null) {
            return null;
        }
        return StaticImportInfo.create(importedName, canonicalName);
    }

    private static StaticImportInfo tryAsStaticMember(JCTree.JCFieldAccess access, VisitorState state) {
        Name identifier = access.getIdentifier();
        if (identifier.contentEquals("*")) {
            return null;
        }
        String importedTypeName = access.getExpression().toString();
        Type importedType = state.getTypeFromString(importedTypeName);
        if (importedType == null) {
            return null;
        }
        Types types = state.getTypes();
        Type canonicalType = types.erasure(importedType);
        if (canonicalType == null) {
            return null;
        }
        Symbol sym = ASTHelpers.getSymbol((Tree)access.getExpression());
        if (!(sym instanceof Symbol.TypeSymbol)) {
            return null;
        }
        Symbol.TypeSymbol baseType = (Symbol.TypeSymbol)sym;
        Symbol.PackageSymbol pkgSym = ((JCTree.JCCompilationUnit)state.getPath().getCompilationUnit()).packge;
        ImmutableSet<Symbol> members = StaticImports.lookup(baseType, baseType, identifier, types, pkgSym);
        if (members.isEmpty()) {
            return null;
        }
        Type canonicalOwner = null;
        for (Symbol member : members) {
            Type owner = types.erasure(member.owner.type);
            if (canonicalOwner != null && !types.isSubtype(owner, canonicalOwner)) continue;
            canonicalOwner = owner;
        }
        if (canonicalOwner == null) {
            return null;
        }
        return StaticImportInfo.create(importedTypeName, canonicalOwner.toString(), identifier.toString(), members);
    }

    private static ImmutableSet<Symbol> lookup(Symbol.TypeSymbol typeSym, Symbol.TypeSymbol start, Name identifier, Types types, Symbol.PackageSymbol pkg) {
        if (typeSym == null) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder members = ImmutableSet.builder();
        members.addAll(StaticImports.lookup(types.supertype((Type)typeSym.type).tsym, start, identifier, types, pkg));
        for (Type i : types.interfaces(typeSym.type)) {
            members.addAll(StaticImports.lookup(i.tsym, start, identifier, types, pkg));
        }
        block5: for (Symbol member : typeSym.members().getSymbolsByName(identifier)) {
            if (!member.isStatic()) continue;
            switch ((int)(member.flags() & 7L)) {
                case 2: {
                    continue block5;
                }
                case 0: 
                case 4: {
                    if (member.packge() == pkg) break;
                    continue block5;
                }
            }
            if (!member.isMemberOf(start, types)) continue;
            members.add((Object)member);
        }
        return members.build();
    }

    @AutoValue
    public static abstract class StaticImportInfo {
        public abstract String importedName();

        public abstract String canonicalName();

        public abstract Optional<String> simpleName();

        public abstract ImmutableSet<Symbol> members();

        public boolean isCanonical() {
            return this.canonicalName().equals(this.importedName());
        }

        public String importStatement() {
            if (this.members().isEmpty()) {
                return String.format("import %s;", this.canonicalName());
            }
            return String.format("import static %s.%s;", this.canonicalName(), this.simpleName().get());
        }

        private static StaticImportInfo create(String importedName, String canonicalName) {
            return new AutoValue_StaticImports_StaticImportInfo(importedName, canonicalName, (Optional<String>)Optional.absent(), (ImmutableSet<Symbol>)ImmutableSet.of());
        }

        private static StaticImportInfo create(String importedName, String canonicalName, String simpleName, Iterable<Symbol> members) {
            return new AutoValue_StaticImports_StaticImportInfo(importedName, canonicalName, (Optional<String>)Optional.of((Object)simpleName), (ImmutableSet<Symbol>)ImmutableSet.copyOf(members));
        }
    }
}

