/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;

@BugPattern(name="NonRuntimeAnnotation", summary="Calling getAnnotation on an annotation that is not retained at runtime.", explanation="Calling getAnnotation on an annotation that does not have its Retention set to RetentionPolicy.RUNTIME will always return null.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR)
public class NonRuntimeAnnotation
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> MATCHER = MethodMatchers.instanceMethod().onExactClass("java.lang.Class").named("getAnnotation").withParameters(new String[]{"java.lang.Class"});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        Type classType = ASTHelpers.getType((Tree)((Tree)Iterables.getOnlyElement(tree.getArguments())));
        if (classType == null || classType.getTypeArguments().isEmpty()) {
            return Description.NO_MATCH;
        }
        Type type = ASTHelpers.getUpperBound((Type)((Type)Iterables.getOnlyElement(classType.getTypeArguments())), (Types)state.getTypes());
        if (ASTHelpers.isSameType((Type)type, (Type)state.getSymtab().annotationType, (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        Attribute.RetentionPolicy retention = state.getTypes().getRetention(type.asElement());
        switch (retention) {
            case RUNTIME: {
                break;
            }
            case SOURCE: 
            case CLASS: {
                return this.buildDescription(tree).setMessage(String.format("%s; %s has %s retention", new Object[]{this.message(), type.asElement().getSimpleName(), retention})).build();
            }
        }
        return Description.NO_MATCH;
    }
}

