/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.scanner.ScannerSupplier;
import com.sun.tools.javac.util.Context;
import java.util.ServiceLoader;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;

public class ErrorPronePlugins {
    private static final Function<BugChecker, Class<? extends BugChecker>> GET_CLASS = new Function<BugChecker, Class<? extends BugChecker>>(){

        public Class<? extends BugChecker> apply(BugChecker input) {
            return input.getClass();
        }
    };

    public static ScannerSupplier loadPlugins(ScannerSupplier scannerSupplier, Context context) {
        JavaFileManager fileManager = context.get(JavaFileManager.class);
        if (!fileManager.hasLocation(StandardLocation.ANNOTATION_PROCESSOR_PATH)) {
            return scannerSupplier;
        }
        ClassLoader loader = fileManager.getClassLoader(StandardLocation.ANNOTATION_PROCESSOR_PATH);
        ServiceLoader<BugChecker> extraBugCheckers = ServiceLoader.load(BugChecker.class, loader);
        if (Iterables.isEmpty(extraBugCheckers)) {
            return scannerSupplier;
        }
        return scannerSupplier.plus(ScannerSupplier.fromBugCheckerClasses(Iterables.transform(extraBugCheckers, GET_CLASS)));
    }
}

