/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.devtools.build.lib.skyframe.serialization.AutoRegistry;
import com.google.devtools.build.lib.skyframe.serialization.Memoizer;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodecRegistry;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

public class SerializationContext {
    private final ObjectCodecRegistry registry;
    private final ImmutableMap<Class<?>, Object> dependencies;
    @Nullable
    private final Memoizer.Serializer serializer;

    private SerializationContext(ObjectCodecRegistry registry, ImmutableMap<Class<?>, Object> dependencies, @Nullable Memoizer.Serializer serializer) {
        this.registry = registry;
        this.dependencies = dependencies;
        this.serializer = serializer;
    }

    @VisibleForTesting
    public SerializationContext(ObjectCodecRegistry registry, ImmutableMap<Class<?>, Object> dependencies) {
        this(registry, dependencies, null);
    }

    @VisibleForTesting
    public SerializationContext(ImmutableMap<Class<?>, Object> dependencies) {
        this(AutoRegistry.get(), dependencies);
    }

    public void serialize(Object object, CodedOutputStream codedOut) throws IOException, SerializationException {
        ObjectCodecRegistry.CodecDescriptor descriptor = this.recordAndGetDescriptorIfNotConstantMemoizedOrNull(object, codedOut);
        if (descriptor != null) {
            if (this.serializer == null) {
                descriptor.serialize(this, object, codedOut);
            } else {
                ObjectCodec<?> castCodec = descriptor.getCodec();
                this.serializer.serialize(this, object, castCodec, codedOut);
            }
        }
    }

    public <T> T getDependency(Class<T> type) {
        Preconditions.checkNotNull(type);
        return (T)this.dependencies.get(type);
    }

    @CheckReturnValue
    public SerializationContext getMemoizingContext() {
        if (this.serializer != null) {
            return this;
        }
        return new SerializationContext(this.registry, this.dependencies, new Memoizer.Serializer());
    }

    private boolean writeNullOrConstant(@Nullable Object object, CodedOutputStream codedOut) throws IOException {
        if (object == null) {
            codedOut.writeSInt32NoTag(0);
            return true;
        }
        Integer tag = this.registry.maybeGetTagForConstant(object);
        if (tag != null) {
            codedOut.writeSInt32NoTag(tag.intValue());
            return true;
        }
        return false;
    }

    @Nullable
    private ObjectCodecRegistry.CodecDescriptor recordAndGetDescriptorIfNotConstantMemoizedOrNull(@Nullable Object object, CodedOutputStream codedOut) throws IOException, SerializationException.NoCodecException {
        Integer memoizedIndex;
        if (this.writeNullOrConstant(object, codedOut)) {
            return null;
        }
        if (this.serializer != null && (memoizedIndex = this.serializer.getMemoizedIndex(object)) != null) {
            codedOut.writeSInt32NoTag(-memoizedIndex.intValue() - 1);
            return null;
        }
        ObjectCodecRegistry.CodecDescriptor descriptor = this.registry.getCodecDescriptorForObject(object);
        codedOut.writeSInt32NoTag(descriptor.getTag());
        return descriptor;
    }
}

