/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.DynamicCodec;
import com.google.devtools.build.lib.skyframe.serialization.EnumCodec;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class ObjectCodecRegistry {
    private final boolean allowDefaultCodec;
    private final ImmutableMap<Class<?>, CodecDescriptor> classMappedCodecs;
    private final ImmutableList<CodecDescriptor> tagMappedCodecs;
    private final int constantsStartTag;
    private final IdentityHashMap<Object, Integer> constantsMap;
    private final ImmutableList<Object> constants;
    private final ImmutableList<String> classNames;
    private final IdentityHashMap<String, Supplier<CodecDescriptor>> dynamicCodecs;

    static Builder newBuilder() {
        return new Builder();
    }

    private ObjectCodecRegistry(ImmutableSet<ObjectCodec<?>> memoizingCodecs, ImmutableList<Object> constants, ImmutableSortedSet<String> classNames, boolean allowDefaultCodec) {
        this.allowDefaultCodec = allowDefaultCodec;
        int nextTag = 1;
        ImmutableMap.Builder memoizingCodecsBuilder = ImmutableMap.builderWithExpectedSize((int)memoizingCodecs.size());
        ImmutableList.Builder tagMappedMemoizingCodecsBuilder = ImmutableList.builderWithExpectedSize((int)memoizingCodecs.size());
        nextTag = ObjectCodecRegistry.processCodecs(memoizingCodecs, nextTag, (ImmutableList.Builder<CodecDescriptor>)tagMappedMemoizingCodecsBuilder, memoizingCodecsBuilder);
        this.classMappedCodecs = memoizingCodecsBuilder.build();
        this.tagMappedCodecs = tagMappedMemoizingCodecsBuilder.build();
        this.constantsStartTag = nextTag;
        this.constantsMap = new IdentityHashMap();
        for (Object constant : constants) {
            this.constantsMap.put(constant, nextTag++);
        }
        this.constants = constants;
        this.classNames = classNames.asList();
        this.dynamicCodecs = ObjectCodecRegistry.createDynamicCodecs(classNames, nextTag);
    }

    public CodecDescriptor getCodecDescriptorForObject(Object obj) throws SerializationException.NoCodecException {
        Class<Object> type = obj.getClass();
        CodecDescriptor descriptor = this.getCodecDescriptor(type);
        if (descriptor != null) {
            return descriptor;
        }
        if (!this.allowDefaultCodec) {
            throw new SerializationException.NoCodecException("No codec available for " + type + " and default fallback disabled");
        }
        if (obj instanceof Enum) {
            type = ((Enum)obj).getDeclaringClass();
        }
        return this.getDynamicCodecDescriptor(type.getName());
    }

    @Nullable
    private CodecDescriptor getCodecDescriptor(Class<?> type) {
        for (Class<?> nextType = type; nextType != null; nextType = nextType.getSuperclass()) {
            CodecDescriptor result = (CodecDescriptor)this.classMappedCodecs.get(nextType);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    Object maybeGetConstantByTag(int tag) {
        return tag < this.constantsStartTag || tag - this.constantsStartTag >= this.constants.size() ? null : this.constants.get(tag - this.constantsStartTag);
    }

    @Nullable
    Integer maybeGetTagForConstant(Object object) {
        return this.constantsMap.get(object);
    }

    public CodecDescriptor getCodecDescriptorByTag(int tag) throws SerializationException.NoCodecException {
        int tagOffset = tag - 1;
        if (tagOffset < 0) {
            throw new SerializationException.NoCodecException("No codec available for tag " + tag);
        }
        if (tagOffset < this.tagMappedCodecs.size()) {
            return (CodecDescriptor)this.tagMappedCodecs.get(tagOffset);
        }
        tagOffset -= this.tagMappedCodecs.size();
        if (!this.allowDefaultCodec || (tagOffset -= this.constants.size()) < 0 || tagOffset >= this.classNames.size()) {
            throw new SerializationException.NoCodecException("No codec available for tag " + tag);
        }
        return this.getDynamicCodecDescriptor((String)this.classNames.get(tagOffset));
    }

    @VisibleForTesting
    public Builder getBuilder() {
        Builder builder = ObjectCodecRegistry.newBuilder();
        builder.setAllowDefaultCodec(this.allowDefaultCodec);
        for (Map.Entry entry : this.classMappedCodecs.entrySet()) {
            builder.add(((CodecDescriptor)entry.getValue()).getCodec());
        }
        for (Object constant : this.constants) {
            builder.addConstant(constant);
        }
        for (String className : this.classNames) {
            builder.addClassName(className);
        }
        return builder;
    }

    ImmutableList<String> classNames() {
        return this.classNames;
    }

    private static int processCodecs(Iterable<? extends ObjectCodec<?>> memoizingCodecs, int nextTag, ImmutableList.Builder<CodecDescriptor> tagMappedCodecsBuilder, ImmutableMap.Builder<Class<?>, CodecDescriptor> codecsBuilder) {
        for (ObjectCodec codec : ImmutableList.sortedCopyOf(Comparator.comparing(o -> o.getEncodedClass().getName()), memoizingCodecs)) {
            TypedCodecDescriptor codecDescriptor = new TypedCodecDescriptor(nextTag++, codec);
            tagMappedCodecsBuilder.add(codecDescriptor);
            codecsBuilder.put(codec.getEncodedClass(), codecDescriptor);
            for (Class otherClass : codec.additionalEncodedClasses()) {
                codecsBuilder.put(otherClass, codecDescriptor);
            }
        }
        return nextTag;
    }

    private static IdentityHashMap<String, Supplier<CodecDescriptor>> createDynamicCodecs(ImmutableSortedSet<String> classNames, int nextTag) {
        IdentityHashMap<String, Supplier<CodecDescriptor>> dynamicCodecs = new IdentityHashMap<String, Supplier<CodecDescriptor>>(classNames.size());
        for (String className : classNames) {
            int tag = nextTag++;
            dynamicCodecs.put(className, (Supplier<CodecDescriptor>)Suppliers.memoize(() -> ObjectCodecRegistry.createDynamicCodecDescriptor(tag, className)));
        }
        return dynamicCodecs;
    }

    private static CodecDescriptor createDynamicCodecDescriptor(int tag, String className) {
        try {
            Class<?> type = Class.forName(className);
            if (type.isEnum()) {
                return ObjectCodecRegistry.createCodecDescriptorForEnum(tag, type);
            }
            return new TypedCodecDescriptor(tag, new DynamicCodec(Class.forName(className)));
        }
        catch (ReflectiveOperationException e) {
            new SerializationException("Could not create codec for type: " + className, e).printStackTrace();
            return null;
        }
    }

    private static CodecDescriptor createCodecDescriptorForEnum(int tag, Class<?> enumType) {
        return new TypedCodecDescriptor(tag, new EnumCodec(enumType));
    }

    private CodecDescriptor getDynamicCodecDescriptor(String className) throws SerializationException.NoCodecException {
        Supplier<CodecDescriptor> supplier = this.dynamicCodecs.get(className);
        if (supplier == null) {
            throw new SerializationException.NoCodecException("No default codec available for " + className);
        }
        CodecDescriptor descriptor = supplier.get();
        if (descriptor == null) {
            throw new SerializationException.NoCodecException("There was a problem creating a codec for " + className + " check logs for details.");
        }
        return descriptor;
    }

    public static class Builder {
        private final ImmutableSet.Builder<ObjectCodec<?>> codecBuilder = ImmutableSet.builder();
        private final ImmutableList.Builder<Object> constantsBuilder = ImmutableList.builder();
        private final ImmutableSortedSet.Builder<String> classNames = ImmutableSortedSet.naturalOrder();
        private boolean allowDefaultCodec = true;

        public Builder add(ObjectCodec<?> codec) {
            this.codecBuilder.add(codec);
            return this;
        }

        public Builder setAllowDefaultCodec(boolean allowDefaultCodec) {
            this.allowDefaultCodec = allowDefaultCodec;
            return this;
        }

        public Builder addConstant(Object object) {
            this.constantsBuilder.add(object);
            return this;
        }

        public Builder addClassName(String className) {
            this.classNames.add((Object)className);
            return this;
        }

        public ObjectCodecRegistry build() {
            return new ObjectCodecRegistry(this.codecBuilder.build(), this.constantsBuilder.build(), this.classNames.build(), this.allowDefaultCodec);
        }
    }

    private static class TypedCodecDescriptor<T>
    implements CodecDescriptor {
        private final int tag;
        private final ObjectCodec<T> codec;

        private TypedCodecDescriptor(int tag, ObjectCodec<T> codec) {
            this.tag = tag;
            this.codec = codec;
        }

        @Override
        public void serialize(SerializationContext context, Object obj, CodedOutputStream codedOut) throws IOException, SerializationException {
            this.codec.serialize(context, obj, codedOut);
        }

        public T deserialize(DeserializationContext context, CodedInputStream codedIn) throws IOException, SerializationException {
            return this.codec.deserialize(context, codedIn);
        }

        @Override
        public int getTag() {
            return this.tag;
        }

        public ObjectCodec<T> getCodec() {
            return this.codec;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("codec", this.codec).add("tag", this.tag).toString();
        }
    }

    static interface CodecDescriptor {
        public void serialize(SerializationContext var1, Object var2, CodedOutputStream var3) throws IOException, SerializationException;

        public Object deserialize(DeserializationContext var1, CodedInputStream var2) throws IOException, SerializationException;

        public int getTag();

        public ObjectCodec<?> getCodec();
    }
}

