/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.common.base.Preconditions;
import com.google.common.reflect.ClassPath;
import com.google.devtools.build.lib.skyframe.serialization.CodecRegisterer;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodecRegistry;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.RegisteredSingletonDoNotUse;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class CodecScanner {
    private static final Logger log = Logger.getLogger(CodecScanner.class.getName());

    public static ObjectCodecRegistry.Builder initializeCodecRegistry(String packagePrefix) throws IOException, ReflectiveOperationException {
        log.info("Building ObjectCodecRegistry");
        ArrayList codecs = new ArrayList();
        ArrayList registerers = new ArrayList();
        ObjectCodecRegistry.Builder builder = ObjectCodecRegistry.newBuilder();
        CodecScanner.getClassInfos(packagePrefix).forEach(classInfo -> {
            if (classInfo.getName().endsWith("Codec")) {
                CodecScanner.processLikelyCodec(classInfo.load(), codecs);
            } else if (classInfo.getName().endsWith("CodecRegisterer")) {
                CodecScanner.processLikelyRegisterer(classInfo.load(), registerers);
            } else if (classInfo.getName().endsWith("RegisteredSingleton")) {
                CodecScanner.processLikelyConstant(classInfo.load(), builder);
            } else {
                builder.addClassName(classInfo.getName().intern());
            }
        });
        HashSet<Class<? extends ObjectCodec<?>>> alreadyRegistered = CodecScanner.runRegisterers(builder, registerers);
        CodecScanner.applyDefaultRegistration(builder, alreadyRegistered, codecs);
        return builder;
    }

    private static void processLikelyCodec(Class<?> type, ArrayList<Class<? extends ObjectCodec<?>>> codecs) {
        if (!ObjectCodec.class.equals(type) && ObjectCodec.class.isAssignableFrom(type) && !Modifier.isAbstract(type.getModifiers())) {
            codecs.add(type);
        }
    }

    private static void processLikelyRegisterer(Class<?> type, ArrayList<Class<? extends CodecRegisterer<?>>> registerers) {
        if (!CodecRegisterer.class.equals(type) && CodecRegisterer.class.isAssignableFrom(type)) {
            registerers.add(type);
        }
    }

    private static void processLikelyConstant(Class<?> type, ObjectCodecRegistry.Builder builder) {
        Field field;
        if (!RegisteredSingletonDoNotUse.class.isAssignableFrom(type)) {
            return;
        }
        try {
            field = type.getDeclaredField("REGISTERED_SINGLETON_INSTANCE_VAR_NAME_GLFKMEBDQFHOJQKEHHQPGMNQBOBFEJADCMDP");
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(type + " inherits from " + RegisteredSingletonDoNotUse.class + " but does not have a field " + "REGISTERED_SINGLETON_INSTANCE_VAR_NAME_GLFKMEBDQFHOJQKEHHQPGMNQBOBFEJADCMDP", e);
        }
        try {
            builder.addConstant(Preconditions.checkNotNull((Object)field.get(null), (String)"%s %s", (Object)field, type));
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Could not access field " + field + " for " + type, e);
        }
    }

    private static HashSet<Class<? extends ObjectCodec<?>>> runRegisterers(ObjectCodecRegistry.Builder builder, ArrayList<Class<? extends CodecRegisterer<?>>> registerers) throws ReflectiveOperationException {
        HashSet registered = new HashSet();
        for (Class<CodecRegisterer<?>> registererType : registerers) {
            Class<? extends ObjectCodec<?>> objectCodecType = CodecScanner.getObjectCodecType(registererType);
            registered.add(objectCodecType);
            Constructor<CodecRegisterer<?>> constructor = registererType.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            CodecRegisterer<?> registerer = constructor.newInstance(new Object[0]);
            for (ObjectCodec<?> codec : registerer.getCodecsToRegister()) {
                builder.add(codec);
            }
        }
        return registered;
    }

    private static void applyDefaultRegistration(ObjectCodecRegistry.Builder builder, HashSet<Class<? extends ObjectCodec<?>>> alreadyRegistered, ArrayList<Class<? extends ObjectCodec<?>>> codecs) throws ReflectiveOperationException {
        for (Class<ObjectCodec<?>> codecType : codecs) {
            if (alreadyRegistered.contains(codecType)) continue;
            try {
                Constructor<ObjectCodec<?>> constructor = codecType.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                builder.add(constructor.newInstance(new Object[0]));
            }
            catch (NoSuchMethodException e) {
                log.log(Level.FINE, "Skipping registration of " + codecType + " because it had no default constructor.");
            }
        }
    }

    private static Class<? extends ObjectCodec<?>> getObjectCodecType(Class<? extends CodecRegisterer<?>> registererType) {
        Type typeArg = ((ParameterizedType)registererType.getGenericInterfaces()[CodecScanner.getCodecRegistererIndex(registererType)]).getActualTypeArguments()[0];
        Preconditions.checkArgument((boolean)(typeArg instanceof Class), (String)"Illegal CodecRegisterer definition: %s\nCodecRegisterer generic parameter must be reified.", registererType);
        return (Class)typeArg;
    }

    private static int getCodecRegistererIndex(Class<? extends CodecRegisterer<?>> registererType) {
        Class<?>[] interfaces = registererType.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!CodecRegisterer.class.equals(interfaces[i])) continue;
            return i;
        }
        throw new IllegalStateException(registererType + " doesn't directly implement CodecRegisterer");
    }

    private static Stream<ClassPath.ClassInfo> getClassInfos(String packagePrefix) throws IOException {
        return ClassPath.from((ClassLoader)ClassLoader.getSystemClassLoader()).getResources().stream().filter(r -> r instanceof ClassPath.ClassInfo).map(r -> (ClassPath.ClassInfo)r).filter(c -> c.getPackageName().startsWith(packagePrefix)).sorted(Comparator.comparing(ClassPath.ClassInfo::getName));
    }
}

