/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.devtools.build.lib.skyframe.serialization.CodecScanner;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodecRegistry;
import java.io.IOException;

public class AutoRegistry {
    private static final Supplier<ObjectCodecRegistry> SUPPLIER = Suppliers.memoize(AutoRegistry::create);
    private static final String PACKAGE_PREFIX = "com.google.devtools";
    private static final ImmutableList<String> EXTERNAL_CLASS_NAMES_TO_REGISTER = ImmutableList.of((Object)"java.io.FileNotFoundException", (Object)"java.io.IOException");
    private static final ImmutableList<Object> CONSTANTS_TO_REGISTER = ImmutableList.of((Object)Predicates.alwaysTrue(), (Object)Predicates.alwaysFalse(), (Object)Predicates.isNull(), (Object)Predicates.notNull());

    public static ObjectCodecRegistry get() {
        return (ObjectCodecRegistry)SUPPLIER.get();
    }

    private static ObjectCodecRegistry create() {
        try {
            ObjectCodecRegistry.Builder registry = CodecScanner.initializeCodecRegistry(PACKAGE_PREFIX);
            for (String className : EXTERNAL_CLASS_NAMES_TO_REGISTER) {
                registry.addClassName(className);
            }
            for (Object constant : CONSTANTS_TO_REGISTER) {
                registry.addConstant(constant);
            }
            return registry.build();
        }
        catch (IOException | ReflectiveOperationException e) {
            throw new IllegalStateException(e);
        }
    }
}

